/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactionalobjects;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.LockMode;
import org.multiverse.api.Txn;
import org.multiverse.api.exceptions.LockedException;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.Functions;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.predicates.IntPredicate;
import org.multiverse.api.references.TxnInteger;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.GammaStmUtils;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.ThreadLocalGammaObjectPool;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;

public class GammaTxnInteger
extends BaseGammaTxnRef
implements TxnInteger {
    public GammaTxnInteger(int value) {
        this((GammaStm)GlobalStmInstance.getGlobalStmInstance(), value);
    }

    public GammaTxnInteger(GammaTxn tx) {
        this(tx, 0);
    }

    public GammaTxnInteger(GammaTxn tx, int value) {
        super(tx.getConfig().stm, 1);
        this.arriveAndLock(1, 3);
        Tranlocal tranlocal = this.openForConstruction(tx);
        tranlocal.long_value = value;
    }

    public GammaTxnInteger(GammaStm stm) {
        this(stm, 0);
    }

    public GammaTxnInteger(GammaStm stm, int value) {
        super(stm, 1);
        this.long_value = value;
        this.version = 1L;
    }

    @Override
    public final int get() {
        return this.get(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final int get(Txn tx) {
        return this.get(GammaStmUtils.asGammaTxn(tx));
    }

    public final int get(GammaTxn tx) {
        return (int)this.openForRead((GammaTxn)tx, (int)0).long_value;
    }

    @Override
    public int getAndLock(LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), lockMode);
    }

    @Override
    public final int getAndLock(Txn tx, LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.asGammaTxn(tx), lockMode);
    }

    public final int getAndLock(GammaTxn tx, LockMode lockMode) {
        return (int)this.getLong(tx, lockMode);
    }

    @Override
    public final int set(int value) {
        return this.set(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final int set(Txn tx, int value) {
        return this.set(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final int set(GammaTxn tx, int value) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        tranlocal.long_value = value;
        return value;
    }

    @Override
    public final int setAndLock(int value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final int setAndLock(Txn tx, int value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final int setAndLock(GammaTxn tx, int value, LockMode lockMode) {
        return (int)GammaStmUtils.longAsDouble(this.setLong(tx, lockMode, value, false));
    }

    @Override
    public final int getAndSet(int value) {
        return this.getAndSet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final int getAndSet(Txn tx, int value) {
        return this.getAndSet(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final int getAndSet(GammaTxn tx, int value) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        int oldValue = (int)tranlocal.long_value;
        tranlocal.long_value = value;
        return oldValue;
    }

    @Override
    public final int getAndSetAndLock(int value, LockMode lockMode) {
        return this.getAndSetLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final int getAndSetAndLock(Txn tx, int value, LockMode lockMode) {
        return this.getAndSetLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final int getAndSetLock(GammaTxn tx, int value, LockMode lockMode) {
        return (int)this.setLong(tx, lockMode, value, true);
    }

    @Override
    public final int atomicGet() {
        return (int)this.atomicGetLong();
    }

    @Override
    public final int atomicWeakGet() {
        return (int)this.long_value;
    }

    @Override
    public final int atomicSet(int newValue) {
        return (int)this.atomicSetLong(newValue, false);
    }

    @Override
    public final int atomicGetAndSet(int newValue) {
        return (int)this.atomicSetLong(newValue, true);
    }

    @Override
    public final void commute(IntFunction function) {
        this.commute(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final void commute(Txn tx, IntFunction function) {
        this.commute(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final void commute(GammaTxn tx, IntFunction function) {
        this.openForCommute(tx, (Function)function);
    }

    @Override
    public final int atomicAlterAndGet(IntFunction function) {
        return this.atomicAlter(function, false);
    }

    @Override
    public final int atomicGetAndAlter(IntFunction function) {
        return this.atomicAlter(function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int atomicAlter(IntFunction function, boolean returnOld) {
        int newValue;
        if (function == null) {
            throw new NullPointerException("Function can't be null");
        }
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        int oldValue = (int)this.long_value;
        boolean abort = true;
        try {
            newValue = function.call(oldValue);
            abort = false;
        }
        finally {
            if (abort) {
                this.departAfterFailureAndUnlock();
            }
        }
        if (oldValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.long_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return returnOld ? oldValue : newValue;
    }

    @Override
    public final int alterAndGet(IntFunction function) {
        return this.alterAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final int alterAndGet(Txn tx, IntFunction function) {
        return this.alterAndGet(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final int alterAndGet(GammaTxn tx, IntFunction function) {
        return this.alter(tx, function, false);
    }

    @Override
    public final int getAndAlter(IntFunction function) {
        return this.getAndAlter(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final int getAndAlter(Txn tx, IntFunction function) {
        return this.getAndAlter(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final int getAndAlter(GammaTxn tx, IntFunction function) {
        return this.alter(tx, function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int alter(GammaTxn tx, IntFunction function, boolean returnOld) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (function == null) {
            tx.abort();
            throw new NullPointerException("Function can't be null");
        }
        Tranlocal write = this.openForWrite(tx, 0);
        boolean abort = true;
        try {
            int oldValue = (int)write.long_value;
            write.long_value = function.call(oldValue);
            abort = false;
            int n = returnOld ? oldValue : (int)write.long_value;
            return n;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final boolean atomicCompareAndSet(int expectedValue, int newValue) {
        return this.atomicCompareAndSetLong(expectedValue, newValue);
    }

    @Override
    public final int atomicGetAndIncrement(int amount) {
        return this.atomicIncrement(amount, true);
    }

    @Override
    public final int atomicIncrementAndGet(int amount) {
        return this.atomicIncrement(amount, false);
    }

    private int atomicIncrement(int amount, boolean returnOld) {
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        int oldValue = (int)this.long_value;
        if (amount == 0) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        int newValue = oldValue + amount;
        this.long_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return returnOld ? oldValue : newValue;
    }

    @Override
    public final int getAndIncrement(int amount) {
        return this.getAndIncrement(GammaStmUtils.getRequiredThreadLocalGammaTxn(), amount);
    }

    @Override
    public final int getAndIncrement(Txn tx, int amount) {
        return this.getAndIncrement(GammaStmUtils.asGammaTxn(tx), amount);
    }

    public final int getAndIncrement(GammaTxn tx, int amount) {
        return this.increment(tx, amount, true);
    }

    @Override
    public final int incrementAndGet(int amount) {
        return this.incrementAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), amount);
    }

    @Override
    public final int incrementAndGet(Txn tx, int amount) {
        return this.incrementAndGet(GammaStmUtils.asGammaTxn(tx), amount);
    }

    public final int incrementAndGet(GammaTxn tx, int amount) {
        return this.increment(tx, amount, false);
    }

    private int increment(GammaTxn tx, int amount, boolean returnOld) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        int oldValue = (int)tranlocal.long_value;
        tranlocal.long_value += (long)amount;
        return returnOld ? oldValue : (int)tranlocal.long_value;
    }

    @Override
    public final void increment() {
        this.increment(GammaStmUtils.getRequiredThreadLocalGammaTxn(), 1);
    }

    @Override
    public final void increment(Txn tx) {
        this.increment(GammaStmUtils.asGammaTxn(tx), 1);
    }

    @Override
    public final void increment(int amount) {
        this.increment(GammaStmUtils.getRequiredThreadLocalGammaTxn(), amount);
    }

    @Override
    public final void increment(Txn tx, int amount) {
        this.increment(GammaStmUtils.asGammaTxn(tx), amount);
    }

    public final void increment(GammaTxn tx, int amount) {
        this.commute(tx, Functions.incIntFunction(amount));
    }

    @Override
    public final void decrement() {
        this.increment(GammaStmUtils.getRequiredThreadLocalGammaTxn(), -1);
    }

    @Override
    public final void decrement(Txn tx) {
        this.increment(GammaStmUtils.asGammaTxn(tx), -1);
    }

    @Override
    public final void decrement(int amount) {
        this.increment(GammaStmUtils.getRequiredThreadLocalGammaTxn(), -amount);
    }

    @Override
    public final void decrement(Txn tx, int amount) {
        this.increment(GammaStmUtils.asGammaTxn(tx), -amount);
    }

    @Override
    public final void await(int value) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final void await(Txn tx, int value) {
        this.await(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final void await(GammaTxn tx, int value) {
        if (this.get(tx) != value) {
            tx.retry();
        }
    }

    @Override
    public final void await(IntPredicate predicate) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), predicate);
    }

    @Override
    public final void await(Txn tx, IntPredicate predicate) {
        this.await(GammaStmUtils.asGammaTxn(tx), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await(GammaTxn tx, IntPredicate predicate) {
        Tranlocal tranlocal = this.openForRead(tx, 0);
        boolean abort = true;
        try {
            if (!predicate.evaluate((int)tranlocal.long_value)) {
                tx.retry();
            }
            abort = false;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final String toDebugString() {
        return String.format("GammaTxnInteger{orec=%s, version=%s, value=%s, hasListeners=%s)", this.___toOrecString(), this.version, this.long_value, this.listeners != null);
    }

    @Override
    public final String toString() {
        return this.toString(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final String toString(Txn tx) {
        return this.toString(GammaStmUtils.asGammaTxn(tx));
    }

    public final String toString(GammaTxn tx) {
        return Integer.toString(this.get(tx));
    }

    @Override
    public final String atomicToString() {
        return Integer.toString(this.atomicGet());
    }
}

