/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

class ClientTupleRequestBase {
    @Nullable
    private final InternalTransaction tx;
    private final TableViewInternal table;
    private final Tuple tuple;
    @Nullable
    private final Tuple tuple2;
    private final long resourceId;

    private ClientTupleRequestBase(@Nullable InternalTransaction tx, TableViewInternal table, Tuple tuple, @Nullable Tuple tuple2, long resourceId) {
        this.tx = tx;
        this.table = table;
        this.tuple = tuple;
        this.tuple2 = tuple2;
        this.resourceId = resourceId;
    }

    public InternalTransaction tx() {
        assert (this.tx != null) : "tx is null";
        return this.tx;
    }

    public long resourceId() {
        return this.resourceId;
    }

    public TableViewInternal table() {
        return this.table;
    }

    public Tuple tuple() {
        return this.tuple;
    }

    public Tuple tuple2() {
        assert (this.tuple2 != null) : "tuple2 is null";
        return this.tuple2;
    }

    public static CompletableFuture<ClientTupleRequestBase> readAsync(ClientMessageUnpacker in, IgniteTables tables, ClientResourceRegistry resources, @Nullable TxManager txManager, boolean txReadOnly, @Nullable NotificationSender notificationSender, @Nullable HybridTimestampTracker tsTracker, boolean keyOnly) {
        return ClientTupleRequestBase.readAsync(in, tables, resources, txManager, txReadOnly, notificationSender, tsTracker, keyOnly, false);
    }

    public static CompletableFuture<ClientTupleRequestBase> readAsync(ClientMessageUnpacker in, IgniteTables tables, ClientResourceRegistry resources, @Nullable TxManager txManager, boolean txReadOnly, @Nullable NotificationSender notificationSender, @Nullable HybridTimestampTracker tsTracker, boolean keyOnly, boolean readSecondTuple) {
        assert (txManager != null == (tsTracker != null)) : "txManager and tsTracker must be both null or not null";
        int tableId = in.unpackInt();
        long[] resIdHolder = new long[]{0L};
        InternalTransaction tx = txManager == null ? null : ClientTableCommon.readOrStartImplicitTx(in, tsTracker, resources, txManager, txReadOnly, notificationSender, resIdHolder);
        int schemaId = in.unpackInt();
        BitSet noValueSet = in.unpackBitSet();
        byte[] tupleBytes = in.readBinary();
        BitSet noValueSet2 = readSecondTuple ? in.unpackBitSet() : null;
        byte[] tupleBytes2 = readSecondTuple ? in.readBinary() : null;
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> ClientTableCommon.readSchema(schemaId, table).thenApply(schema -> {
            Tuple tuple = ClientTableCommon.readTuple(noValueSet, tupleBytes, keyOnly, schema);
            Tuple tuple2 = readSecondTuple ? ClientTableCommon.readTuple(noValueSet2, tupleBytes2, keyOnly, schema) : null;
            return new ClientTupleRequestBase(tx, (TableViewInternal)table, tuple, tuple2, resIdHolder[0]);
        }));
    }
}

