/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cdc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.cdc.CdcFileLockHolder;
import org.apache.ignite.internal.management.cdc.CdcDeleteLostSegmentLinksCommandArg;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CdcDeleteLostSegmentsTask
extends VisorMultiNodeTask<CdcDeleteLostSegmentLinksCommandArg, Void, Void> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<CdcDeleteLostSegmentLinksCommandArg, Void> job(CdcDeleteLostSegmentLinksCommandArg arg) {
        return new CdcDeleteLostSegmentsJob(arg, false);
    }

    @Override
    @Nullable
    protected Void reduce0(List<ComputeJobResult> results) throws IgniteException {
        for (ComputeJobResult res : results) {
            if (res.getException() == null) continue;
            throw new IgniteException("Failed to delete lost segment CDC links on a node [nodeId=" + res.getNode().id() + "]", res.getException());
        }
        return null;
    }

    private static class CdcDeleteLostSegmentsJob
    extends VisorJob<CdcDeleteLostSegmentLinksCommandArg, Void> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        protected IgniteLogger log;

        protected CdcDeleteLostSegmentsJob(CdcDeleteLostSegmentLinksCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Void run(CdcDeleteLostSegmentLinksCommandArg arg) throws IgniteException {
            FileWriteAheadLogManager wal = (FileWriteAheadLogManager)this.ignite.context().cache().context().wal(true);
            File walCdcDir = wal.walCdcDirectory();
            if (walCdcDir == null) {
                throw new IgniteException("CDC is not configured.");
            }
            CdcFileLockHolder lock = new CdcFileLockHolder(walCdcDir.getAbsolutePath(), "Delete lost segments job", this.log);
            try {
                lock.tryLock(1L);
                try {
                    HashSet delete;
                    Stream<Path> cdcFiles;
                    block17: {
                        cdcFiles = Files.list(walCdcDir.toPath());
                        delete = new HashSet();
                        AtomicLong lastSgmnt = new AtomicLong(-1L);
                        cdcFiles.filter(p -> FileWriteAheadLogManager.WAL_SEGMENT_FILE_FILTER.accept(p.toFile())).sorted(Comparator.comparingLong(FileWriteAheadLogManager::segmentIndex).reversed()).forEach(path -> {
                            long idx = FileWriteAheadLogManager.segmentIndex(path);
                            if (lastSgmnt.get() == -1L || lastSgmnt.get() - idx == 1L) {
                                lastSgmnt.set(idx);
                                return;
                            }
                            delete.add(path.toFile());
                        });
                        if (!delete.isEmpty()) break block17;
                        this.log.info("Lost segment CDC links were not found.");
                        Void void_ = null;
                        if (cdcFiles == null) return void_;
                        cdcFiles.close();
                        return void_;
                    }
                    try {
                        this.log.info("Found lost segment CDC links. The following links will be deleted: " + delete);
                        delete.forEach(file -> {
                            if (!file.delete()) {
                                throw new IgniteException("Failed to delete lost segment CDC link [file=" + file.getAbsolutePath() + "]");
                            }
                            this.log.info("Segment CDC link deleted [file=" + file.getAbsolutePath() + "]");
                        });
                        Path stateDir = walCdcDir.toPath().resolve("state");
                        if (!stateDir.toFile().exists()) return null;
                        File walState = stateDir.resolve("cdc-wal-state.bin").toFile();
                        if (!walState.exists()) return null;
                        if (walState.delete()) return null;
                        throw new IgniteException("Failed to delete wal state file [file=" + walState.getAbsolutePath() + "]");
                    }
                    finally {
                        if (cdcFiles != null) {
                            cdcFiles.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete lost segment CDC links.", e);
                }
            }
            catch (IgniteCheckedException e) {
                throw new RuntimeException("Failed to delete lost segment CDC links. Unable to acquire lock to lock CDC folder. Make sure a CDC app is shut down [dir=" + walCdcDir.getAbsolutePath() + ", reason=" + e.getMessage() + "]");
            }
            finally {
                U.closeQuiet(lock);
            }
        }
    }
}

