/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.management.meta.MetaRemoveCommandArg;
import org.apache.ignite.internal.management.meta.MetadataInfoTask;
import org.apache.ignite.internal.management.meta.MetadataMarshalled;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class MetadataRemoveTask
extends VisorMultiNodeTask<MetaRemoveCommandArg, MetadataMarshalled, MetadataMarshalled> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<MetaRemoveCommandArg, MetadataMarshalled> job(MetaRemoveCommandArg arg) {
        return new MetadataRemoveJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected MetadataMarshalled reduce0(List<ComputeJobResult> results) {
        if (results.size() != 1) {
            throw new IgniteException("Invalid job results. Expected exactly 1 result, but was: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (MetadataMarshalled)results.get(0).getData();
    }

    private static class MetadataRemoveJob
    extends VisorJob<MetaRemoveCommandArg, MetadataMarshalled> {
        private static final long serialVersionUID = 0L;

        protected MetadataRemoveJob(@Nullable MetaRemoveCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        public SecurityPermissionSet requiredPermissions() {
            return SecurityPermissionSetBuilder.systemPermissions(SecurityPermission.ADMIN_METADATA_OPS);
        }

        @Override
        protected MetadataMarshalled run(@Nullable MetaRemoveCommandArg arg) throws IgniteException {
            try {
                assert (Objects.nonNull(arg));
                int typeId = MetadataInfoTask.typeId(this.ignite.context(), arg.typeId(), arg.typeName());
                BinaryMetadata meta = ((CacheObjectBinaryProcessorImpl)this.ignite.context().cacheObjects()).binaryMetadata(typeId);
                if (meta == null) {
                    return new MetadataMarshalled(null, null);
                }
                byte[] marshalled = U.marshal(this.ignite.context(), (Object)meta);
                MetadataMarshalled res = new MetadataMarshalled(marshalled, meta);
                this.ignite.context().cacheObjects().removeType(typeId);
                return res;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }
}

