/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.compute.PrimaryReplicaNextWorkerSelector;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.replicator.PartitionGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

class NextColocatedWorkerSelector<K>
extends PrimaryReplicaNextWorkerSelector {
    private final NodeProperties nodeProperties;
    @Nullable
    private final K key;
    @Nullable
    private final Mapper<K> keyMapper;
    @Nullable
    private final Tuple tuple;
    private final TableViewInternal table;

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, NodeProperties nodeProperties, TableViewInternal table, K key, Mapper<K> keyMapper) {
        this(placementDriver, topologyService, clock, nodeProperties, table, key, keyMapper, null);
    }

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, NodeProperties nodeProperties, TableViewInternal table, Tuple tuple) {
        this(placementDriver, topologyService, clock, nodeProperties, table, null, null, tuple);
    }

    private NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, NodeProperties nodeProperties, TableViewInternal table, @Nullable K key, @Nullable Mapper<K> keyMapper, @Nullable Tuple tuple) {
        super(placementDriver, topologyService, clock);
        this.nodeProperties = nodeProperties;
        this.table = table;
        this.key = key;
        this.keyMapper = keyMapper;
        this.tuple = tuple;
    }

    @Override
    protected PartitionGroupId partitionGroupId() {
        if (this.key != null && this.keyMapper != null) {
            if (this.nodeProperties.colocationEnabled()) {
                return new ZonePartitionId(this.table.zoneId(), this.table.partitionId(this.key, this.keyMapper));
            }
            return new TablePartitionId(this.table.tableId(), this.table.partitionId(this.key, this.keyMapper));
        }
        if (this.nodeProperties.colocationEnabled()) {
            return new ZonePartitionId(this.table.zoneId(), this.table.partitionId(this.tuple));
        }
        return new TablePartitionId(this.table.tableId(), this.table.partitionId(this.tuple));
    }
}

