/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.RemoveByPrefixCommand;
import org.apache.ignite3.internal.metastorage.command.RemoveByPrefixCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.RemoveByPrefixCommandSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class RemoveByPrefixCommandImpl
implements RemoveByPrefixCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 52;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final ByteBuffer prefix;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private RemoveByPrefixCommandImpl(HybridTimestamp initiatorTime, ByteBuffer prefix, HybridTimestamp safeTime) {
        this.initiatorTime = initiatorTime;
        this.prefix = prefix;
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public ByteBuffer prefix() {
        return this.prefix;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return RemoveByPrefixCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(RemoveByPrefixCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 52;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RemoveByPrefixCommandImpl otherMessage = (RemoveByPrefixCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.prefix, otherMessage.prefix) && Objects.equals(this.safeTime, otherMessage.safeTime);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.initiatorTime, this.prefix, this.safeTime);
        return result;
    }

    @Override
    public RemoveByPrefixCommandImpl clone() {
        try {
            return (RemoveByPrefixCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RemoveByPrefixCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RemoveByPrefixCommandBuilder {
        private HybridTimestamp initiatorTime;
        private ByteBuffer prefix;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public RemoveByPrefixCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public RemoveByPrefixCommandBuilder prefix(ByteBuffer prefix) {
            Objects.requireNonNull(prefix, "prefix is not marked @Nullable");
            this.prefix = prefix;
            return this;
        }

        @Override
        public RemoveByPrefixCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public ByteBuffer prefix() {
            return this.prefix;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public RemoveByPrefixCommand build() {
            return new RemoveByPrefixCommandImpl(Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), Objects.requireNonNull(this.prefix, "prefix is not marked @Nullable"), this.safeTime);
        }
    }
}

