/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.ScanCloseReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ScanCloseReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.ScanCloseReplicaRequestSerializer;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ScanCloseReplicaRequestImpl
implements ScanCloseReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final long scanId;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;

    private ScanCloseReplicaRequestImpl(ReplicationGroupIdMessage groupId, long scanId, int tableId, HybridTimestamp timestamp, UUID transactionId) {
        this.groupId = groupId;
        this.scanId = scanId;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public long scanId() {
        return this.scanId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    public MessageSerializer serializer() {
        return ScanCloseReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ScanCloseReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ScanCloseReplicaRequestImpl otherMessage = (ScanCloseReplicaRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.scanId == otherMessage.scanId && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.scanId, this.tableId, this.groupId, this.timestamp, this.transactionId);
        return result;
    }

    @Override
    public ScanCloseReplicaRequestImpl clone() {
        try {
            return (ScanCloseReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ScanCloseReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ScanCloseReplicaRequestBuilder {
        private ReplicationGroupIdMessage groupId;
        private long scanId;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;

        private Builder() {
        }

        @Override
        public ScanCloseReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ScanCloseReplicaRequestBuilder scanId(long scanId) {
            this.scanId = scanId;
            return this;
        }

        @Override
        public ScanCloseReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ScanCloseReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ScanCloseReplicaRequestBuilder transactionId(UUID transactionId) {
            Objects.requireNonNull(transactionId, "transactionId is not marked @Nullable");
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public long scanId() {
            return this.scanId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public ScanCloseReplicaRequest build() {
            return new ScanCloseReplicaRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.scanId, this.tableId, this.timestamp, Objects.requireNonNull(this.transactionId, "transactionId is not marked @Nullable"));
        }
    }
}

