/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteLogicalIndexScan
extends AbstractIndexScan {
    private static final String REL_TYPE_NAME = "LogicalIndexScan";

    public static IgniteLogicalIndexScan create(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, String idxName, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        List<SearchBounds> searchBounds;
        IgniteTable tbl = (IgniteTable)table.unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(cluster);
        IgniteIndex index = tbl.indexes().get(idxName);
        RelCollation collation = index.collation();
        if (index.type() == IgniteIndex.Type.HASH) {
            if (requiredColumns != null) {
                Mapping targetMapping = Commons.projectedMapping(tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount(), requiredColumns);
                RelCollation outputCollation = (RelCollation)collation.apply((Mappings.TargetMapping)targetMapping);
                searchBounds = collation.getFieldCollations().size() == outputCollation.getFieldCollations().size() ? IgniteLogicalIndexScan.buildHashIndexConditions(cluster, tbl, outputCollation, cond, requiredColumns) : null;
            } else {
                searchBounds = IgniteLogicalIndexScan.buildHashIndexConditions(cluster, tbl, collation, cond, requiredColumns);
            }
        } else if (index.type() == IgniteIndex.Type.SORTED) {
            if (requiredColumns != null) {
                Mapping targetMapping = Commons.projectedMapping(tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount(), requiredColumns);
                collation = (RelCollation)collation.apply((Mappings.TargetMapping)targetMapping);
            }
            searchBounds = IgniteLogicalIndexScan.buildSortedIndexConditions(cluster, tbl, collation, cond, requiredColumns);
        } else {
            throw new AssertionError((Object)("Unknown index type [type=" + index.type() + "]"));
        }
        return new IgniteLogicalIndexScan(cluster, traits, table, idxName, index.type(), names, proj, cond, searchBounds, requiredColumns);
    }

    private IgniteLogicalIndexScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, IgniteIndex.Type type, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableIntList requiredCols) {
        super(cluster, traits, List.of(), tbl, idxName, type, names, proj, cond, searchBounds, requiredCols);
    }

    @Nullable
    private static List<SearchBounds> buildSortedIndexConditions(RelOptCluster cluster, IgniteTable table, RelCollation collation, @Nullable RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        if (collation.getFieldCollations().isEmpty()) {
            return null;
        }
        return RexUtils.buildSortedSearchBounds(cluster, collation, cond, table.getRowType((RelDataTypeFactory)Commons.typeFactory(cluster)), requiredColumns);
    }

    private static List<SearchBounds> buildHashIndexConditions(RelOptCluster cluster, IgniteTable table, RelCollation collation, RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        return RexUtils.buildHashSearchBounds(cluster, collation, cond, table.getRowType((RelDataTypeFactory)Commons.typeFactory(cluster)), requiredColumns);
    }

    @Override
    protected IgniteLogicalIndexScan copy(@Nullable List<RexNode> newProjects, @Nullable RexNode newCondition, @Nullable List<SearchBounds> newSearchBounds) {
        return new IgniteLogicalIndexScan(this.getCluster(), this.getTraitSet(), this.getTable(), this.indexName(), this.type, this.names, newProjects, newCondition, newSearchBounds, this.requiredColumns());
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

