/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.MapReduceAggregates;
import org.apache.ignite3.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.HintUtils;
import org.apache.ignite3.internal.sql.engine.util.PlanUtils;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class SortAggregateConverterRule {
    public static final RelOptRule COLOCATED = new ColocatedSortAggregateConverterRule();
    public static final RelOptRule MAP_REDUCE = new MapReduceSortAggregateConverterRule();

    private SortAggregateConverterRule() {
    }

    private static class ColocatedSortAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        ColocatedSortAggregateConverterRule() {
            super(LogicalAggregate.class, "ColocatedSortAggregateConverterRule");
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(0);
            return !HintUtils.isExpandDistinctAggregate(aggregate) && aggregate.getGroupSets().size() == 1;
        }

        @Override
        @Nullable
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            RelCollation collation = TraitUtils.createCollation(agg.getGroupSet().asList());
            RelOptCluster cluster = agg.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation).replace((RelTrait)IgniteDistributions.single());
            RelNode input = ColocatedSortAggregateConverterRule.convert((RelNode)agg.getInput(), (RelTraitSet)inTrait);
            return new IgniteColocatedSortAggregate(cluster, outTrait, input, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }
    }

    private static class MapReduceSortAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        MapReduceSortAggregateConverterRule() {
            super(LogicalAggregate.class, "MapReduceSortAggregateConverterRule");
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(0);
            return !HintUtils.isExpandDistinctAggregate(aggregate) && (CollectionUtils.nullOrEmpty(aggregate.getGroupSet()) || aggregate.getGroupSets().size() == 1) && MapReduceAggregates.canBeImplementedAsMapReduce(aggregate.getAggCallList()) && !PlanUtils.complexDistinctAgg(aggregate.getAggCallList());
        }

        @Override
        @Nullable
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, final LogicalAggregate agg) {
            RelOptCluster cluster = agg.getCluster();
            final RelCollation collation = TraitUtils.createCollation(agg.getGroupSet().asList());
            Mapping fieldMappingOnReduce = Commons.trimmingMapping(agg.getGroupSet().length(), agg.getGroupSet());
            final RelCollation outputCollation = (RelCollation)collation.apply((Mappings.TargetMapping)fieldMappingOnReduce);
            final RelTraitSet inTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation);
            final RelTraitSet outTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)outputCollation);
            MapReduceAggregates.AggregateRelBuilder relBuilder = new MapReduceAggregates.AggregateRelBuilder(){

                @Override
                public IgniteRel makeMapAgg(RelOptCluster cluster, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggregateCalls) {
                    return new IgniteMapSortAggregate(cluster, outTraits.replace((RelTrait)IgniteDistributions.random()), RelOptRule.convert((RelNode)input, (RelTraitSet)inTraits.replace((RelTrait)IgniteDistributions.random())), groupSet, groupSets, aggregateCalls, collation);
                }

                @Override
                public IgniteRel makeProject(RelOptCluster cluster, RelNode input, List<RexNode> reduceInputExprs, RelDataType projectRowType) {
                    return new IgniteProject(agg.getCluster(), outTraits.replace((RelTrait)IgniteDistributions.single()), RelOptRule.convert((RelNode)input, (RelTraitSet)outTraits.replace((RelTrait)IgniteDistributions.single())), reduceInputExprs, projectRowType);
                }

                @Override
                public IgniteRel makeReduceAgg(RelOptCluster cluster, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggregateCalls, RelDataType outputType) {
                    return new IgniteReduceSortAggregate(cluster, outTraits.replace((RelTrait)IgniteDistributions.single()), RelOptRule.convert((RelNode)input, (RelTraitSet)outTraits.replace((RelTrait)IgniteDistributions.single())), groupSet, groupSets, aggregateCalls, outputType, outputCollation);
                }
            };
            return MapReduceAggregates.buildAggregates(agg, relBuilder, fieldMappingOnReduce);
        }
    }
}

