/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class IdentityWeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final long serialVersionUID = -5176951017503351630L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient WeakEntry<K, V>[] entries;
    protected transient int count = 0;
    private transient int modCount = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;
    protected ReferenceQueue referenceQueue;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();

    public IdentityWeakHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.entries = new WeakEntry[capacity];
        this.referenceQueue = new ReferenceQueue();
    }

    public IdentityWeakHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityWeakHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new WeakEntry[32];
        this.referenceQueue = new ReferenceQueue();
    }

    public IdentityWeakHashMap(Map m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(m);
    }

    @Override
    public int size() {
        this.cleanUp();
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_not_supported_identityweakhashmap"));
        }
        this.cleanUp();
        WeakEntry<K, V>[] copyOfEntries = this.entries;
        int i = copyOfEntries.length;
        while (i-- > 0) {
            WeakEntry<K, V> e = copyOfEntries[i];
            while (e != null) {
                if (obj.equals(e.value.get())) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_not_supported_identityweakhashmap"));
        }
        this.cleanUp();
        WeakEntry<K, V>[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        WeakEntry<K, V> e = copyOfEntries[index];
        while (e != null) {
            if (e.key.get() == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        this.cleanUp();
        WeakEntry<K, V>[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        WeakEntry<K, V> e = copyOfEntries[index];
        while (e != null) {
            if (e.key.get() == key) {
                return e.value.get();
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.entries.length;
        WeakEntry<K, V>[] oldEntries = this.entries;
        int newCapacity = oldCapacity * 2 + 1;
        WeakEntry[] newEntries = new WeakEntry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = newEntries;
        int i = oldCapacity;
        while (i-- > 0) {
            WeakEntry<K, V> old = oldEntries[i];
            while (old != null) {
                WeakEntry<K, V> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newEntries[index];
                newEntries[index] = e;
            }
        }
    }

    @Override
    public V put(K key, V obj) {
        if (obj == null || key == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_not_supported_identityweakhashmap"));
        }
        this.cleanUp();
        WeakEntry<K, V>[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        WeakEntry<K, V> e = copyOfEntries[index];
        while (e != null) {
            if (e.key.get() == key) {
                EntryReference old = e.value;
                e.value = key == obj ? e.key : new HardEntryReference<V>(obj);
                return old.get();
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            copyOfEntries = this.entries;
            index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        }
        copyOfEntries[index] = e = new WeakEntry<K, V>(hash, key, obj, copyOfEntries[index], this.referenceQueue);
        ++this.count;
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        this.cleanUp();
        WeakEntry<K, V>[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        WeakEntry<K, V> e = copyOfEntries[index];
        WeakEntry<K, V> prev = null;
        while (e != null) {
            if (e.key.get() == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    copyOfEntries[index] = e.next;
                }
                --this.count;
                return e.value.get();
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    protected boolean removeEntry(Map.Entry o, boolean userModification) {
        WeakEntry<K, V>[] copyOfEntries = this.entries;
        int index = (((WeakEntry)o).hash & Integer.MAX_VALUE) % copyOfEntries.length;
        WeakEntry<K, V> e = copyOfEntries[index];
        WeakEntry<K, V> prev = null;
        while (e != null) {
            if (e == o) {
                if (userModification) {
                    ++this.modCount;
                }
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    copyOfEntries[index] = e.next;
                }
                --this.count;
                e.value = null;
                e.next = null;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<K, V> me : m.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public void clear() {
        if (this.count > 0) {
            ++this.modCount;
            WeakEntry<K, V>[] copyOfEntries = this.entries;
            int i = copyOfEntries.length;
            while (--i >= 0) {
                copyOfEntries[i] = null;
            }
            this.count = 0;
        }
    }

    protected void cleanUp() {
        WeakEntryReference reference = (WeakEntryReference)this.referenceQueue.poll();
        while (reference != null) {
            this.removeEntry(reference.owner, false);
            reference = (WeakEntryReference)this.referenceQueue.poll();
        }
    }

    @Override
    public Object clone() {
        try {
            WeakEntry<K, V>[] copyOfEntries = this.entries;
            IdentityWeakHashMap clone = (IdentityWeakHashMap)super.clone();
            clone.referenceQueue = new ReferenceQueue();
            clone.entries = new WeakEntry[copyOfEntries.length];
            int i = copyOfEntries.length;
            while (i-- > 0) {
                clone.entries[i] = copyOfEntries[i] != null ? (WeakEntry)copyOfEntries[i].clone(clone.referenceQueue) : null;
            }
            clone.keySet = null;
            clone.entrySet = null;
            clone.values = null;
            clone.modCount = 0;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityWeakHashMap.this.getHashIterator(COMPONENT_TYPES.KEYS);
                }

                @Override
                public int size() {
                    return IdentityWeakHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return IdentityWeakHashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    int oldSize = IdentityWeakHashMap.this.count;
                    IdentityWeakHashMap.this.remove(o);
                    return IdentityWeakHashMap.this.count != oldSize;
                }

                @Override
                public void clear() {
                    IdentityWeakHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return IdentityWeakHashMap.this.getHashIterator(COMPONENT_TYPES.VALUES);
                }

                @Override
                public int size() {
                    return IdentityWeakHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return IdentityWeakHashMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    IdentityWeakHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityWeakHashMap.this.getHashIterator(COMPONENT_TYPES.ENTRIES);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    WeakEntry<K, V>[] copyOfEntries = IdentityWeakHashMap.this.entries;
                    int hash = System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
                    WeakEntry e = copyOfEntries[index];
                    while (e != null) {
                        if (e.hash == hash && e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof WeakEntry)) {
                        return false;
                    }
                    WeakEntry entry = (WeakEntry)o;
                    return IdentityWeakHashMap.this.removeEntry(entry, true);
                }

                @Override
                public int size() {
                    return IdentityWeakHashMap.this.count;
                }

                @Override
                public void clear() {
                    IdentityWeakHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Iterator getHashIterator(COMPONENT_TYPES type) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(type);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.entries.length);
        s.writeInt(this.count);
        for (int i = this.entries.length - 1; i >= 0; --i) {
            WeakEntry<K, V> entry = this.entries[i];
            while (entry != null) {
                s.writeObject(entry.key.get());
                s.writeObject(entry.value.get());
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.entries = new WeakEntry[numBuckets];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null || value == null) continue;
            this.put(key, value);
        }
    }

    private class HashIterator
    implements Iterator {
        WeakEntry[] entries;
        int index;
        WeakEntry entry;
        WeakEntry lastReturned;
        COMPONENT_TYPES type;
        Object currentEntryRef;
        private int expectedModCount;

        HashIterator(COMPONENT_TYPES type) {
            this.entries = IdentityWeakHashMap.this.entries;
            this.index = this.entries.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IdentityWeakHashMap.this.modCount;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            WeakEntry e = this.entry;
            int i = this.index;
            WeakEntry<K, V>[] copyOfEntries = IdentityWeakHashMap.this.entries;
            while ((e == null || this.currentEntryRef == null) && i > 0) {
                if ((e = copyOfEntries[--i]) != null) {
                    this.currentEntryRef = e.key.get();
                    continue;
                }
                this.currentEntryRef = null;
            }
            this.entry = e;
            this.index = i;
            return e != null && this.currentEntryRef != null;
        }

        public Object next() {
            if (IdentityWeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakEntry et = this.entry;
            int i = this.index;
            WeakEntry<K, V>[] copyOfEntries = IdentityWeakHashMap.this.entries;
            while ((et == null || this.currentEntryRef == null) && i > 0) {
                if ((et = copyOfEntries[--i]) != null) {
                    this.currentEntryRef = et.key.get();
                    continue;
                }
                this.currentEntryRef = null;
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                WeakEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                this.currentEntryRef = this.entry != null ? this.entry.key.get() : null;
                return this.type == COMPONENT_TYPES.KEYS ? e.key.get() : (this.type == COMPONENT_TYPES.VALUES ? e.value.get() : e);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IdentityWeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakEntry<K, V>[] copyOfEntries = IdentityWeakHashMap.this.entries;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % copyOfEntries.length;
            WeakEntry e = copyOfEntries[index];
            WeakEntry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    ++IdentityWeakHashMap.this.modCount;
                    ++this.expectedModCount;
                    if (prev == null) {
                        copyOfEntries[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --IdentityWeakHashMap.this.count;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static enum COMPONENT_TYPES {
        KEYS,
        VALUES,
        ENTRIES;

    }

    static class HardEntryReference<T>
    implements EntryReference {
        protected T referent;

        public HardEntryReference(T referent) {
            this.referent = referent;
        }

        @Override
        public T get() {
            return this.referent;
        }
    }

    static class WeakEntryReference<T>
    extends WeakReference<T>
    implements EntryReference {
        protected WeakEntry owner;
        protected boolean trashed = false;
        protected ReferenceQueue referenceQueue;

        public WeakEntryReference(T referent, ReferenceQueue<? super T> q, WeakEntry owner) {
            super(referent, q);
            this.owner = owner;
            this.referenceQueue = q;
        }
    }

    static interface EntryReference<T> {
        public T get();
    }

    static class WeakEntry<K, V>
    implements Map.Entry<K, V> {
        boolean removed = false;
        int hash;
        EntryReference<K> key;
        EntryReference<V> value;
        WeakEntry<K, V> next;

        WeakEntry(int hash, K key, V value, WeakEntry<K, V> next, ReferenceQueue refQueue) {
            this.hash = hash;
            this.key = new WeakEntryReference<K>(key, refQueue, this);
            this.value = key == value ? this.key : new HardEntryReference<V>(value);
            this.next = next;
        }

        protected Object clone(ReferenceQueue refQueue) {
            WeakEntry<K, V> root;
            WeakEntry<K, V> current = this;
            WeakEntry<K, V> currentClone = root = new WeakEntry<K, V>(current.hash, current.key.get(), current.value.get(), null, refQueue);
            while (current.next != null) {
                currentClone.next = new WeakEntry<K, V>(current.next.hash, current.next.key.get(), current.next.value.get(), null, refQueue);
                current = current.next;
                currentClone = currentClone.next;
            }
            return root;
        }

        @Override
        public K getKey() {
            return this.key.get();
        }

        @Override
        public V getValue() {
            return this.value.get();
        }

        @Override
        public V setValue(V value) {
            EntryReference<V> oldValue = this.value;
            this.value = value == this.key.get() ? this.key : new HardEntryReference<V>(value);
            return oldValue.get();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            V v = this.value.get();
            return this.key == e.getKey() && (v == null ? e.getValue() == null : v.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            V v = this.value.get();
            return this.hash ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.key.get() + "=" + this.value.get();
        }

        public boolean shouldBeIgnored() {
            return this.key.get() == null || this.value.get() == null;
        }
    }
}

