/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.PlanStatus;
import org.apache.iceberg.rest.responses.BaseScanTaskResponse;

public class FetchPlanningResultResponse
extends BaseScanTaskResponse {
    private final PlanStatus planStatus;

    private FetchPlanningResultResponse(PlanStatus planStatus, List<String> planTasks, List<FileScanTask> fileScanTasks, List<DeleteFile> deleteFiles, Map<Integer, PartitionSpec> specsById) {
        super(planTasks, fileScanTasks, deleteFiles, specsById);
        this.planStatus = planStatus;
        this.validate();
    }

    public PlanStatus planStatus() {
        return this.planStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.planStatus() != null ? 1 : 0) != 0, (Object)"Invalid status: null");
        Preconditions.checkArgument((this.planStatus() == PlanStatus.COMPLETED || this.planTasks() == null && this.fileScanTasks() == null ? 1 : 0) != 0, (Object)"Invalid response: tasks can only be returned in a 'completed' status");
        if (this.fileScanTasks() == null || this.fileScanTasks().isEmpty()) {
            Preconditions.checkArgument((this.deleteFiles() == null || this.deleteFiles().isEmpty() ? 1 : 0) != 0, (Object)"Invalid response: deleteFiles should only be returned with fileScanTasks that reference them");
        }
    }

    public static class Builder
    extends BaseScanTaskResponse.Builder<Builder, FetchPlanningResultResponse> {
        private PlanStatus planStatus;

        private Builder() {
        }

        public Builder withPlanStatus(PlanStatus status) {
            this.planStatus = status;
            return this;
        }

        @Override
        public FetchPlanningResultResponse build() {
            return new FetchPlanningResultResponse(this.planStatus, this.planTasks(), this.fileScanTasks(), this.deleteFiles(), this.specsById());
        }
    }
}

