/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.reactivemessaging;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.smallrye.reactive.messaging.observation.DefaultMessageObservation;
import io.smallrye.reactive.messaging.observation.MessageObservation;
import io.smallrye.reactive.messaging.observation.MessageObservationCollector;
import io.smallrye.reactive.messaging.observation.ObservationContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class MicrometerObservationCollector
implements MessageObservationCollector<MicrometerContext> {
    @Inject
    @ConfigProperty(name="quarkus.messaging.observation.micrometer.enabled", defaultValue="true")
    boolean enabled;

    public MicrometerContext initObservation(String channel, boolean incoming, boolean emitter) {
        if (this.enabled) {
            return new MicrometerContext(channel);
        }
        return null;
    }

    public MessageObservation onNewMessage(String channel, Message<?> message, MicrometerContext ctx) {
        ctx.msgCount.increment();
        return new DefaultMessageObservation(channel);
    }

    public static class MicrometerContext
    implements ObservationContext {
        final Counter msgCount;
        final Timer duration;
        final Counter acks;
        final Counter nacks;

        public MicrometerContext(String channel) {
            Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"channel", (String)channel)});
            this.msgCount = Counter.builder((String)"quarkus.messaging.message.count").description("The number of messages observed").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.duration = Timer.builder((String)"quarkus.messaging.message.duration").description("The duration of the message processing").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.acks = Counter.builder((String)"quarkus.messaging.message.acks").description("The number of messages processed successfully").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.nacks = Counter.builder((String)"quarkus.messaging.message.failures").description("The number of messages processed with failures").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        }

        public void complete(MessageObservation observation) {
            if (observation.getReason() == null) {
                this.acks.increment();
            } else {
                this.nacks.increment();
            }
            this.duration.record(observation.getCompletionDuration());
        }
    }
}

