/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.openpgp.PGPKeyLoader;
import org.apache.sshd.openpgp.PGPPrivateKeyExtractor;
import org.apache.sshd.openpgp.PGPPublicKeyExtractor;
import org.bouncycastle.openpgp.PGPException;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.Subkey;

public class PGPKeyPairResourceParser
extends AbstractKeyPairResourceParser
implements PGPKeyLoader,
PGPPublicKeyExtractor,
PGPPrivateKeyExtractor {
    public static final String BEGIN_MARKER = "BEGIN PGP PRIVATE KEY BLOCK";
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN PGP PRIVATE KEY BLOCK"));
    public static final String END_MARKER = "END PGP PRIVATE KEY BLOCK";
    public static final List<String> ENDERS = Collections.unmodifiableList(Collections.singletonList("END PGP PRIVATE KEY BLOCK"));
    public static final PGPKeyPairResourceParser INSTANCE = new PGPKeyPairResourceParser();

    public PGPKeyPairResourceParser() {
        super(BEGINNERS, ENDERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, List<String> lines, Map<String, String> headers) throws IOException, GeneralSecurityException {
        String eol = System.lineSeparator();
        int numLines = GenericUtils.size(lines);
        StringBuilder sb = new StringBuilder(beginMarker.length() + endMarker.length() + 4 + numLines * 80).append(beginMarker);
        if (numLines > 0) {
            for (String l : lines) {
                sb.append(eol).append(l);
            }
        }
        sb.append(eol).append(endMarker).append(eol);
        String keyData = sb.toString();
        byte[] dataBytes = keyData.getBytes(StandardCharsets.US_ASCII);
        try {
            Collection collection = this.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, dataBytes, headers);
            return collection;
        }
        finally {
            Arrays.fill(dataBytes, (byte)0);
        }
    }

    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream, Map<String, String> headers) throws IOException, GeneralSecurityException {
        int retryCount = 0;
        while (true) {
            block14: {
                List<KeyPair> keys;
                String password = passwordProvider == null ? null : passwordProvider.getPassword(session, resourceKey, retryCount);
                try {
                    if (retryCount > 0) {
                        stream.reset();
                    }
                    Key key = PGPKeyLoader.loadPGPKey(stream, password);
                    keys = this.extractKeyPairs(resourceKey, key.getSubkeys());
                }
                catch (IOException | RuntimeException | GeneralSecurityException | PGPException e) {
                    FilePasswordProvider.ResourceDecodeResult result;
                    FilePasswordProvider.ResourceDecodeResult resourceDecodeResult = result = passwordProvider != null ? passwordProvider.handleDecodeAttemptResult(session, resourceKey, retryCount, password, (Exception)e) : FilePasswordProvider.ResourceDecodeResult.TERMINATE;
                    if (result == null) {
                        result = FilePasswordProvider.ResourceDecodeResult.TERMINATE;
                    }
                    switch (result) {
                        case TERMINATE: {
                            if (e instanceof PGPException) {
                                throw new StreamCorruptedException("Failed (" + e.getClass().getSimpleName() + ") to decode " + resourceKey + ": " + e.getMessage());
                            }
                            if (e instanceof IOException) {
                                throw (IOException)e;
                            }
                            if (e instanceof GeneralSecurityException) {
                                throw (GeneralSecurityException)e;
                            }
                            throw (RuntimeException)e;
                        }
                        case RETRY: {
                            break block14;
                        }
                        case IGNORE: {
                            return Collections.emptyList();
                        }
                        default: {
                            throw new ProtocolException("Unsupported decode attempt result (" + result + ") for " + resourceKey);
                        }
                    }
                }
                if (passwordProvider != null) {
                    passwordProvider.handleDecodeAttemptResult(session, resourceKey, retryCount, password, null);
                }
                return keys;
            }
            ++retryCount;
        }
    }

    public List<KeyPair> extractKeyPairs(NamedResource resourceKey, Collection<? extends Subkey> subKeys) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(subKeys)) {
            return Collections.emptyList();
        }
        ArrayList<KeyPair> kpList = new ArrayList<KeyPair>(subKeys.size());
        boolean debugEnabled = this.log.isDebugEnabled();
        for (Subkey subkey : subKeys) {
            KeyPair prev;
            PrivateKey prvKey;
            PublicKey pubKey;
            try {
                pubKey = this.extractPublicKey(resourceKey, subkey);
                if (pubKey == null) {
                    if (!debugEnabled) continue;
                    this.log.debug("extractKeyPairs({}) no public key extracted from {}", (Object)resourceKey, (Object)subkey);
                    continue;
                }
            }
            catch (IOException | Error | RuntimeException | GeneralSecurityException e2) {
                this.log.error("extractKeyPairs({}) failed ({}) to extract public key of {}: {}", new Object[]{resourceKey, e2.getClass().getSimpleName(), subkey, e2.getMessage()});
                throw e2;
            }
            try {
                prvKey = this.extractPrivateKey(resourceKey, subkey, pubKey);
                if (prvKey == null) {
                    if (!debugEnabled) continue;
                    this.log.debug("extractKeyPairs({}) no private key extracted from {}", (Object)resourceKey, (Object)subkey);
                    continue;
                }
            }
            catch (IOException | Error | RuntimeException | GeneralSecurityException e3) {
                this.log.error("extractKeyPairs({}) failed ({}) to extract private key of {}: {}", new Object[]{resourceKey, e3.getClass().getSimpleName(), subkey, e3.getMessage()});
                throw e3;
            }
            catch (PGPException e4) {
                this.log.error("extractKeyPairs({}) failed ({}) to parse private key of {}: {}", new Object[]{resourceKey, ((Object)((Object)e4)).getClass().getSimpleName(), subkey, e4.getMessage()});
                throw new StreamCorruptedException("Failed to parse " + resourceKey + " sub-key=" + subkey + ": " + e4.getMessage());
            }
            KeyPair kp = new KeyPair(pubKey, prvKey);
            KeyPair keyPair = prev = kpList.isEmpty() ? null : (KeyPair)kpList.stream().filter(e -> KeyUtils.compareKeyPairs((KeyPair)e, (KeyPair)kp)).findFirst().orElse(null);
            if (prev != null) {
                if (!debugEnabled) continue;
                this.log.debug("extractKeyPairs({}) skip duplicate sub-key={}", (Object)resourceKey, (Object)subkey);
                continue;
            }
            kpList.add(kp);
        }
        return kpList;
    }

    @Override
    public <K extends PublicKey> K generatePublicKey(String algorithm, Class<K> keyType, KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactory(algorithm);
        PublicKey pubKey = factory.generatePublic(keySpec);
        return (K)((PublicKey)keyType.cast(pubKey));
    }

    @Override
    public <K extends PrivateKey> K generatePrivateKey(String algorithm, Class<K> keyType, KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactory(algorithm);
        PrivateKey prvKey = factory.generatePrivate(keySpec);
        return (K)((PrivateKey)keyType.cast(prvKey));
    }

    protected KeyFactory getKeyFactory(String algorithm) throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory((String)algorithm);
    }
}

