/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.auth;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.SignRequest;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;

public class AuthHeaderLoader {
    private final List<AuthHeaderProvider> authHeaderProviders = SPIServiceUtils.getSortedService(AuthHeaderProvider.class);
    private static final AuthHeaderLoader INSTANCE = new AuthHeaderLoader();

    private AuthHeaderLoader() {
    }

    public static AuthHeaderLoader getInstance() {
        return INSTANCE;
    }

    public Map<String, String> loadAuthHeaders(SignRequest signRequest) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.authHeaderProviders.forEach(provider -> result.putAll(provider.getSignAuthHeaders(signRequest)));
        return result;
    }
}

