/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.recipes.queue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.storm.shade.org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEvent;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEventType;
import org.apache.storm.shade.org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.api.WatchPathable;
import org.apache.storm.shade.org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.storm.shade.org.apache.curator.framework.listen.Listenable;
import org.apache.storm.shade.org.apache.curator.framework.listen.StandardListenerManager;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.ChildrenCache;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.ErrorMode;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.ItemSerializer;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.MultiItem;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.QueueBase;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.QueueConsumer;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.QueuePutListener;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.QueueSerializer;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.storm.shade.org.apache.curator.utils.CloseableUtils;
import org.apache.storm.shade.org.apache.curator.utils.PathUtils;
import org.apache.storm.shade.org.apache.curator.utils.ThreadUtils;
import org.apache.storm.shade.org.apache.curator.utils.ZKPaths;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueue<T>
implements QueueBase<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final QueueSerializer<T> serializer;
    private final String queuePath;
    private final Executor executor;
    private final ExecutorService service;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final QueueConsumer<T> consumer;
    private final int minItemsBeforeRefresh;
    private final boolean refreshOnWatch;
    private final boolean isProducerOnly;
    private final String lockPath;
    private final AtomicReference<ErrorMode> errorMode = new AtomicReference<ErrorMode>(ErrorMode.REQUEUE);
    private final StandardListenerManager<QueuePutListener<T>> putListenerContainer = StandardListenerManager.standard();
    private final AtomicInteger lastChildCount = new AtomicInteger(0);
    private final int maxItems;
    private final int finalFlushMs;
    private final boolean putInBackground;
    private final ChildrenCache childrenCache;
    private final AtomicInteger putCount = new AtomicInteger(0);
    private static final String QUEUE_ITEM_NAME = "queue-";

    DistributedQueue(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath, ThreadFactory threadFactory, Executor executor, int minItemsBeforeRefresh, boolean refreshOnWatch, String lockPath, int maxItems, boolean putInBackground, int finalFlushMs) {
        Preconditions.checkNotNull(client, "client cannot be null");
        Preconditions.checkNotNull(serializer, "serializer cannot be null");
        Preconditions.checkNotNull(threadFactory, "threadFactory cannot be null");
        Preconditions.checkNotNull(executor, "executor cannot be null");
        Preconditions.checkArgument(maxItems > 0, "maxItems must be a positive number");
        this.isProducerOnly = consumer == null;
        this.lockPath = lockPath == null ? null : PathUtils.validatePath(lockPath);
        this.putInBackground = putInBackground;
        this.consumer = consumer;
        this.minItemsBeforeRefresh = minItemsBeforeRefresh;
        this.refreshOnWatch = refreshOnWatch;
        this.client = client;
        this.serializer = serializer;
        this.queuePath = PathUtils.validatePath(queuePath);
        this.executor = executor;
        this.maxItems = maxItems;
        this.finalFlushMs = finalFlushMs;
        this.service = Executors.newFixedThreadPool(2, threadFactory);
        this.childrenCache = new ChildrenCache(client, queuePath);
        if (maxItems != Integer.MAX_VALUE && putInBackground) {
            this.log.warn("Bounded queues should set putInBackground(false) in the builder. Putting in the background will result in spotty maxItem consistency.");
        }
    }

    @Override
    public void start() throws Exception {
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            throw new IllegalStateException();
        }
        try {
            this.client.create().creatingParentContainersIfNeeded().forPath(this.queuePath);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        if (this.lockPath != null) {
            try {
                this.client.create().creatingParentContainersIfNeeded().forPath(this.lockPath);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        if (!this.isProducerOnly || this.maxItems != Integer.MAX_VALUE) {
            this.childrenCache.start();
        }
        if (!this.isProducerOnly) {
            this.service.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    DistributedQueue.this.runLoop();
                    return null;
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            if (this.finalFlushMs > 0) {
                try {
                    this.flushPuts(this.finalFlushMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            CloseableUtils.closeQuietly(this.childrenCache);
            this.putListenerContainer.clear();
            this.service.shutdownNow();
        }
    }

    @Override
    public Listenable<QueuePutListener<T>> getPutListenerContainer() {
        return this.putListenerContainer;
    }

    @Override
    public void setErrorMode(ErrorMode newErrorMode) {
        Preconditions.checkNotNull(this.lockPath, "lockPath cannot be null");
        if (newErrorMode == ErrorMode.REQUEUE) {
            this.log.warn("ErrorMode.REQUEUE requires ZooKeeper version 3.4.x+ - make sure you are not using a prior version");
        }
        this.errorMode.set(newErrorMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushPuts(long waitTime, TimeUnit timeUnit) throws InterruptedException {
        long msWaitRemaining = TimeUnit.MILLISECONDS.convert(waitTime, timeUnit);
        AtomicInteger atomicInteger = this.putCount;
        synchronized (atomicInteger) {
            while (this.putCount.get() > 0) {
                if (msWaitRemaining <= 0L) {
                    return false;
                }
                long startMs = System.currentTimeMillis();
                this.putCount.wait(msWaitRemaining);
                long elapsedMs = System.currentTimeMillis() - startMs;
                msWaitRemaining -= elapsedMs;
            }
        }
        return true;
    }

    public void put(T item) throws Exception {
        this.put(item, 0, null);
    }

    public boolean put(T item, int maxWait, TimeUnit unit) throws Exception {
        this.checkState();
        String path = this.makeItemPath();
        return this.internalPut(item, null, path, maxWait, unit);
    }

    public void putMulti(MultiItem<T> items) throws Exception {
        this.putMulti(items, 0, null);
    }

    public boolean putMulti(MultiItem<T> items, int maxWait, TimeUnit unit) throws Exception {
        this.checkState();
        String path = this.makeItemPath();
        return this.internalPut(null, items, path, maxWait, unit);
    }

    @Override
    public int getLastMessageCount() {
        return this.lastChildCount.get();
    }

    boolean internalPut(T item, MultiItem<T> multiItem, String path, int maxWait, TimeUnit unit) throws Exception {
        if (!this.blockIfMaxed(maxWait, unit)) {
            return false;
        }
        MultiItem givenMultiItem = multiItem;
        if (item != null) {
            final AtomicReference<T> ref = new AtomicReference<T>(item);
            multiItem = new MultiItem<T>(){

                @Override
                public T nextItem() throws Exception {
                    return ref.getAndSet(null);
                }
            };
        }
        this.putCount.incrementAndGet();
        byte[] bytes = ItemSerializer.serialize(multiItem, this.serializer);
        if (this.putInBackground) {
            this.doPutInBackground(item, path, givenMultiItem, bytes);
        } else {
            this.doPutInForeground(item, path, givenMultiItem, bytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutInForeground(T item, String path, MultiItem<T> givenMultiItem, byte[] bytes) throws Exception {
        ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(path, bytes);
        AtomicInteger atomicInteger = this.putCount;
        synchronized (atomicInteger) {
            this.putCount.decrementAndGet();
            this.putCount.notifyAll();
        }
        this.putListenerContainer.forEach((Consumer<QueuePutListener<QueuePutListener>>)((Consumer<QueuePutListener>)listener -> {
            if (item != null) {
                listener.putCompleted(item);
            } else {
                listener.putMultiCompleted(givenMultiItem);
            }
        }));
    }

    private void doPutInBackground(final T item, String path, final MultiItem<T> givenMultiItem, byte[] bytes) throws Exception {
        BackgroundCallback callback = new BackgroundCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                if (event.getResultCode() != KeeperException.Code.OK.intValue()) {
                    return;
                }
                if (event.getType() == CuratorEventType.CREATE) {
                    AtomicInteger atomicInteger = DistributedQueue.this.putCount;
                    synchronized (atomicInteger) {
                        DistributedQueue.this.putCount.decrementAndGet();
                        DistributedQueue.this.putCount.notifyAll();
                    }
                }
                DistributedQueue.this.putListenerContainer.forEach(listener -> {
                    if (item != null) {
                        listener.putCompleted(item);
                    } else {
                        listener.putMultiCompleted(givenMultiItem);
                    }
                });
            }
        };
        this.internalCreateNode(path, bytes, callback);
    }

    @VisibleForTesting
    void internalCreateNode(String path, byte[] bytes, BackgroundCallback callback) throws Exception {
        ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).inBackground(callback)).forPath(path, bytes);
    }

    void checkState() throws Exception {
        if (this.state.get() != State.STARTED) {
            throw new IllegalStateException();
        }
    }

    String makeItemPath() {
        return ZKPaths.makePath(this.queuePath, QUEUE_ITEM_NAME);
    }

    @VisibleForTesting
    ChildrenCache getCache() {
        return this.childrenCache;
    }

    protected void sortChildren(List<String> children) {
        Collections.sort(children);
    }

    protected List<String> getChildren() throws Exception {
        return (List)this.client.getChildren().forPath(this.queuePath);
    }

    protected long getDelay(String itemNode) {
        return 0L;
    }

    protected boolean tryRemove(String itemNode) throws Exception {
        boolean isUsingLockSafety;
        boolean bl = isUsingLockSafety = this.lockPath != null;
        if (isUsingLockSafety) {
            return this.processWithLockSafety(itemNode, ProcessType.REMOVE);
        }
        return this.processNormally(itemNode, ProcessType.REMOVE);
    }

    private boolean blockIfMaxed(int maxWait, TimeUnit unit) throws Exception {
        ChildrenCache.Data data = this.childrenCache.getData();
        while (data.children.size() >= this.maxItems) {
            long previousVersion = data.version;
            data = this.childrenCache.blockingNextGetData(data.version, maxWait, unit);
            if (data.version != previousVersion) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runLoop() {
        long currentVersion = -1L;
        long maxWaitMs = -1L;
        try {
            while (this.state.get() == State.STARTED) {
                try {
                    ChildrenCache.Data data = maxWaitMs > 0L ? this.childrenCache.blockingNextGetData(currentVersion, maxWaitMs, TimeUnit.MILLISECONDS) : this.childrenCache.blockingNextGetData(currentVersion);
                    currentVersion = data.version;
                    ArrayList<String> children = Lists.newArrayList(data.children);
                    this.sortChildren(children);
                    if (children.size() <= 0 || (maxWaitMs = this.getDelay((String)children.get(0))) > 0L) continue;
                    this.processChildren(children, currentVersion);
                }
                catch (InterruptedException data) {}
            }
            return;
        }
        catch (Exception e) {
            this.log.error("Exception caught in background handler", (Throwable)e);
        }
    }

    private void processChildren(List<String> children, long currentVersion) throws Exception {
        final Semaphore processedLatch = new Semaphore(0);
        final boolean isUsingLockSafety = this.lockPath != null;
        int min = this.minItemsBeforeRefresh;
        for (final String itemNode : children) {
            if (Thread.currentThread().isInterrupted()) {
                processedLatch.release(children.size());
                break;
            }
            if (!itemNode.startsWith(QUEUE_ITEM_NAME)) {
                this.log.warn("Foreign node in queue path: " + itemNode);
                processedLatch.release();
                continue;
            }
            if (min-- <= 0 && this.refreshOnWatch && currentVersion != this.childrenCache.getData().version) {
                processedLatch.release(children.size());
                break;
            }
            if (this.getDelay(itemNode) > 0L) {
                processedLatch.release();
                continue;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (isUsingLockSafety) {
                            DistributedQueue.this.processWithLockSafety(itemNode, ProcessType.NORMAL);
                        } else {
                            DistributedQueue.this.processNormally(itemNode, ProcessType.NORMAL);
                        }
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted(e);
                        DistributedQueue.this.log.error("Error processing message at " + itemNode, (Throwable)e);
                    }
                    finally {
                        processedLatch.release();
                    }
                }
            });
        }
        processedLatch.acquire(children.size());
    }

    private ProcessMessageBytesCode processMessageBytes(String itemNode, byte[] bytes) throws Exception {
        T item;
        MultiItem<T> items;
        ProcessMessageBytesCode resultCode = ProcessMessageBytesCode.NORMAL;
        try {
            items = ItemSerializer.deserialize(bytes, this.serializer);
        }
        catch (Throwable e) {
            ThreadUtils.checkInterrupted(e);
            this.log.error("Corrupted queue item: " + itemNode, e);
            return resultCode;
        }
        while ((item = items.nextItem()) != null) {
            try {
                this.consumer.consumeMessage(item);
            }
            catch (Throwable e) {
                ThreadUtils.checkInterrupted(e);
                this.log.error("Exception processing queue item: " + itemNode, e);
                if (this.errorMode.get() != ErrorMode.REQUEUE) continue;
                resultCode = ProcessMessageBytesCode.REQUEUE;
                break;
            }
        }
        return resultCode;
    }

    private boolean processNormally(String itemNode, ProcessType type) throws Exception {
        try {
            String itemPath = ZKPaths.makePath(this.queuePath, itemNode);
            Stat stat = new Stat();
            byte[] bytes = null;
            if (type == ProcessType.NORMAL) {
                bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(itemPath);
            }
            if (this.client.getState() == CuratorFrameworkState.STARTED) {
                ((BackgroundPathable)this.client.delete().withVersion(stat.getVersion())).forPath(itemPath);
            }
            if (type == ProcessType.NORMAL) {
                this.processMessageBytes(itemNode, bytes);
            }
            return true;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (KeeperException.BadVersionException badVersionException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected boolean processWithLockSafety(String itemNode, ProcessType type) throws Exception {
        String lockNodePath = ZKPaths.makePath(this.lockPath, itemNode);
        boolean lockCreated = false;
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(lockNodePath);
            lockCreated = true;
            String itemPath = ZKPaths.makePath(this.queuePath, itemNode);
            boolean requeue = false;
            byte[] bytes = null;
            if (type == ProcessType.NORMAL) {
                bytes = (byte[])this.client.getData().forPath(itemPath);
                boolean bl = requeue = this.processMessageBytes(itemNode, bytes) == ProcessMessageBytesCode.REQUEUE;
            }
            if (requeue) {
                ((CuratorTransactionBridge)((ACLPathAndBytesable)((CuratorTransactionBridge)this.client.inTransaction().delete().forPath(itemPath)).and().create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(this.makeRequeueItemPath(itemPath), bytes)).and().commit();
            } else {
                this.client.delete().forPath(itemPath);
            }
            boolean bl = true;
            return bl;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (KeeperException.BadVersionException badVersionException) {
        }
        finally {
            if (lockCreated) {
                ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(lockNodePath);
            }
        }
        return false;
    }

    protected String makeRequeueItemPath(String itemPath) {
        return this.makeItemPath();
    }

    private static enum ProcessMessageBytesCode {
        NORMAL,
        REQUEUE;

    }

    @VisibleForTesting
    protected static enum ProcessType {
        NORMAL,
        REMOVE;

    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

