/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.ClientMetricsUtils;
import org.apache.storm.metrics2.filters.StormMetricsFilter;
import org.apache.storm.metrics2.reporters.ScheduledStormReporter;
import org.apache.storm.metrics2.reporters.StormReporter;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxStormReporter
implements StormReporter {
    public static final String JMX_DOMAIN = "jmx.domain";
    private static final Logger LOG = LoggerFactory.getLogger(JmxStormReporter.class);
    JmxReporter reporter = null;

    public static String getMetricsJmxDomain(Map reporterConf) {
        return ObjectReader.getString(reporterConf.get(JMX_DOMAIN), null);
    }

    @Override
    public void prepare(MetricRegistry metricsRegistry, Map<String, Object> topoConf, Map<String, Object> reporterConf) {
        StormMetricsFilter filter;
        String domain;
        TimeUnit rateUnit;
        LOG.info("Preparing...");
        JmxReporter.Builder builder = JmxReporter.forRegistry((MetricRegistry)metricsRegistry);
        TimeUnit durationUnit = ClientMetricsUtils.getMetricsDurationUnit(reporterConf);
        if (durationUnit != null) {
            builder.convertDurationsTo(durationUnit);
        }
        if ((rateUnit = ClientMetricsUtils.getMetricsRateUnit(reporterConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((domain = JmxStormReporter.getMetricsJmxDomain(reporterConf)) != null) {
            builder.inDomain(domain);
        }
        if ((filter = ScheduledStormReporter.getMetricsFilter(reporterConf)) != null) {
            builder.filter((MetricFilter)filter);
        }
        this.reporter = builder.build();
    }

    @Override
    public void start() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to start without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Starting...");
        this.reporter.start();
    }

    @Override
    public void stop() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to stop without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Stopping...");
        this.reporter.stop();
    }

    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }
}

