/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.keymaster.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.syncope.core.persistence.api.dao.ConfParamDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.ConfParam;
import org.apache.syncope.core.persistence.api.entity.SelfKeymasterEntityFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class InternalConfParamHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(InternalConfParamHelper.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final ConfParamDAO confParamDAO;
    protected final SelfKeymasterEntityFactory entityFactory;

    public InternalConfParamHelper(ConfParamDAO confParamDAO, SelfKeymasterEntityFactory entityFactory) {
        this.confParamDAO = confParamDAO;
        this.entityFactory = entityFactory;
    }

    @Transactional(readOnly=true)
    public Map<String, Object> list() {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        this.confParamDAO.findAll().forEach(param -> {
            try {
                params.put(param.getKey(), MAPPER.treeToValue((TreeNode)param.getValue(), Object.class));
            }
            catch (JsonProcessingException e) {
                LOG.error("While processing {}'s value", (Object)param.getKey(), (Object)e);
            }
        });
        return params;
    }

    @Transactional(readOnly=true)
    public JsonNode get(String key) {
        ConfParam param = this.confParamDAO.find(key);
        return Optional.ofNullable(param).map(ConfParam::getValue).orElse(null);
    }

    @Transactional
    public void set(String key, JsonNode value) {
        if (value == null) {
            throw new NotFoundException("No value provided for " + key);
        }
        ConfParam param = this.confParamDAO.find(key);
        if (param == null) {
            param = this.entityFactory.newConfParam();
            param.setKey(key);
        }
        param.setValue(value);
        this.confParamDAO.save(param);
    }

    @Transactional
    public void remove(String key) {
        this.confParamDAO.delete(key);
    }
}

