/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Base64;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.GuardedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

class GuardedStringDeserializer
extends JsonDeserializer<GuardedString> {
    private static final Logger LOG = LoggerFactory.getLogger(GuardedStringDeserializer.class);
    private static final String READONLY = "readOnly";
    private static final String DISPOSED = "disposed";
    private static final String ENCRYPTED_BYTES = "encryptedBytes";
    private static final String BASE64_SHA1_HASH = "base64SHA1Hash";
    private static final String LOG_ERROR_MESSAGE = "Could not set field value to {}";

    GuardedStringDeserializer() {
    }

    public GuardedString deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        Field field;
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        boolean readOnly = false;
        if (tree.has(READONLY)) {
            readOnly = tree.get(READONLY).asBoolean();
        }
        boolean disposed = false;
        if (tree.has(DISPOSED)) {
            disposed = tree.get(DISPOSED).asBoolean();
        }
        byte[] encryptedBytes = null;
        if (tree.has(ENCRYPTED_BYTES)) {
            encryptedBytes = Base64.getDecoder().decode(tree.get(ENCRYPTED_BYTES).asText());
        }
        String base64SHA1Hash = null;
        if (tree.has(BASE64_SHA1_HASH)) {
            base64SHA1Hash = tree.get(BASE64_SHA1_HASH).asText();
        }
        byte[] clearBytes = EncryptorFactory.getInstance().getDefaultEncryptor().decrypt(encryptedBytes);
        GuardedString dest = new GuardedString(new String(clearBytes).toCharArray());
        try {
            field = GuardedString.class.getDeclaredField(READONLY);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)dest, (Object)readOnly);
        }
        catch (Exception e) {
            LOG.error(LOG_ERROR_MESSAGE, (Object)readOnly, (Object)e);
        }
        try {
            field = GuardedString.class.getDeclaredField(DISPOSED);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)dest, (Object)disposed);
        }
        catch (Exception e) {
            LOG.error(LOG_ERROR_MESSAGE, (Object)disposed, (Object)e);
        }
        if (base64SHA1Hash != null) {
            try {
                field = GuardedString.class.getDeclaredField(BASE64_SHA1_HASH);
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)dest, (Object)base64SHA1Hash);
            }
            catch (Exception e) {
                LOG.error(LOG_ERROR_MESSAGE, (Object)base64SHA1Hash, (Object)e);
            }
        }
        return dest;
    }
}

