/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCByteBufferFactory {
    private static int FIXED_BUFFER_SIZE = 4096;
    private static final int WARN_THRESHOLD = 0xA00000;
    private static final TCByteBuffer ZERO_BYTE_BUFFER = TCByteBufferImpl.wrap(new byte[0]);
    private static final Logger logger = LoggerFactory.getLogger(TCByteBufferFactory.class);

    public static TCByteBuffer getInstance(int size) {
        if (size > 0xA00000) {
            logger.warn("Asking for a large amount of memory: " + size + " bytes");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Requested length cannot be less than zero");
        }
        if (size == 0) {
            return ZERO_BYTE_BUFFER;
        }
        return new TCByteBufferImpl(size, false);
    }

    public static void setFixedBufferSize(int size) {
        if (size > 512 && size < 0x2000000) {
            FIXED_BUFFER_SIZE = size;
        } else {
            logger.warn("fixed buffer size ignored, outside sane range {}", (Object)size);
        }
    }

    public static int getFixedBufferSize() {
        return FIXED_BUFFER_SIZE;
    }

    public static TCByteBuffer getDirectByteBuffer() {
        return new TCByteBufferImpl(FIXED_BUFFER_SIZE, true);
    }

    public static TCByteBuffer wrap(byte[] buf) {
        if (buf == null) {
            return null;
        }
        return TCByteBufferImpl.wrap(buf);
    }

    public static byte[] unwrap(TCByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.isReadOnly() || buffer.isDirect() || buffer.position() != 0 || buffer.remaining() != buffer.array().length || buffer.arrayOffset() != 0) {
            byte[] array = new byte[buffer.remaining()];
            TCByteBuffer b = buffer.slice();
            while (b.hasRemaining()) {
                b.get(array, b.position(), b.remaining());
            }
            return array;
        }
        return buffer.array();
    }

    public static TCByteBuffer copyAndWrap(byte[] buf) {
        TCByteBuffer rv;
        if (buf != null) {
            rv = TCByteBufferFactory.getInstance(buf.length);
            rv.put(buf).rewind();
        } else {
            rv = TCByteBufferFactory.getInstance(0);
        }
        return rv;
    }
}

