/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ServerSideConfiguration
implements Serializable {
    private static final long serialVersionUID = -6203570000622687613L;
    private final String defaultServerResource;
    private final Map<String, Pool> resourcePools;

    public ServerSideConfiguration(Map<String, Pool> resourcePools) {
        HashSet<String> badPools = new HashSet<String>();
        for (Map.Entry<String, Pool> e : resourcePools.entrySet()) {
            if (e.getValue().getServerResource() != null) continue;
            badPools.add(e.getKey());
        }
        if (!badPools.isEmpty()) {
            throw new IllegalArgumentException("Pools " + badPools + " define no explicit server resource, and no default server resource was specified");
        }
        this.defaultServerResource = null;
        this.resourcePools = new HashMap<String, Pool>(resourcePools);
    }

    public ServerSideConfiguration(String defaultServerResource, Map<String, Pool> resourcePools) {
        if (defaultServerResource == null) {
            throw new NullPointerException("Default server resource cannot be null");
        }
        this.defaultServerResource = defaultServerResource;
        this.resourcePools = new HashMap<String, Pool>(resourcePools);
    }

    public String getDefaultServerResource() {
        return this.defaultServerResource;
    }

    public Map<String, Pool> getResourcePools() {
        return Collections.unmodifiableMap(this.resourcePools);
    }

    public static final class Pool
    implements Serializable {
        private static final long serialVersionUID = 3920576607695314256L;
        private final String serverResource;
        private final long size;

        public Pool(long size, String serverResource) {
            if (size <= 0L) {
                throw new IllegalArgumentException("Pool must have a positive size");
            }
            this.size = size;
            this.serverResource = serverResource;
        }

        public Pool(long size) {
            if (size <= 0L) {
                throw new IllegalArgumentException("Pool must have a positive size");
            }
            this.size = size;
            this.serverResource = null;
        }

        public long getSize() {
            return this.size;
        }

        public String getServerResource() {
            return this.serverResource;
        }

        public String toString() {
            return "[" + this.getSize() + " bytes from '" + (this.getServerResource() == null ? "<default>" : this.getServerResource()) + "']";
        }

        public int hashCode() {
            return (this.serverResource != null ? this.serverResource.hashCode() : 0) ^ (int)this.size ^ (int)(this.size >>> 32);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pool other = (Pool)obj;
            if (this.size != other.size) {
                return false;
            }
            return !(this.serverResource == null ? other.serverResource != null : !this.serverResource.equals(other.serverResource));
        }
    }
}

