/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntityManager;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateExecutionRelatedEntityCountCfgCmd
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateExecutionRelatedEntityCountCfgCmd.class);
    public static final String PROPERTY_EXECUTION_RELATED_ENTITY_COUNT = "cfg.execution-related-entities-count";

    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        PropertyEntityManager propertyEntityManager = processEngineConfiguration.getPropertyEntityManager();
        boolean configProperty = processEngineConfiguration.getPerformanceSettings().isEnableExecutionRelationshipCounts();
        PropertyEntity propertyEntity = (PropertyEntity)propertyEntityManager.findById(PROPERTY_EXECUTION_RELATED_ENTITY_COUNT);
        if (propertyEntity == null) {
            PropertyEntity newPropertyEntity = (PropertyEntity)propertyEntityManager.create();
            newPropertyEntity.setName(PROPERTY_EXECUTION_RELATED_ENTITY_COUNT);
            newPropertyEntity.setValue(Boolean.toString(configProperty));
            propertyEntityManager.insert((Entity)newPropertyEntity);
        } else {
            boolean propertyValue = Boolean.valueOf(propertyEntity.getValue().toLowerCase());
            if (!configProperty && propertyValue) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Configuration change: execution related entity counting feature was enabled before, but now disabled. Updating all execution entities.");
                }
                processEngineConfiguration.getExecutionDataManager().updateAllExecutionRelatedEntityCountFlags(configProperty);
            }
            if (configProperty != propertyValue) {
                propertyEntity.setValue(Boolean.toString(configProperty));
                propertyEntityManager.update((Entity)propertyEntity);
            }
        }
        return null;
    }
}

