/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import com.nimbusds.jose.Header;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20JwtAccessTokenEncoder
implements CipherExecutor<String, String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20JwtAccessTokenEncoder.class);
    private final JwtBuilder accessTokenJwtBuilder;
    private final OAuth20AccessToken accessToken;
    private final RegisteredService registeredService;
    private final Service service;
    private final CasConfigurationProperties casProperties;
    private final String issuer;
    private final OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;

    public String decode(String tokenId, Object[] parameters) {
        try {
            Object serviceId;
            if (StringUtils.isBlank((CharSequence)tokenId)) {
                LOGGER.warn("No access token is provided to decode");
                return null;
            }
            Header header = JWTParser.parse((String)tokenId).getHeader();
            OAuthRegisteredService oAuthRegisteredService = (OAuthRegisteredService)this.registeredService;
            if (oAuthRegisteredService == null && (serviceId = header.getCustomParam(RegisteredServiceCipherExecutor.CUSTOM_HEADER_REGISTERED_SERVICE_ID)) != null) {
                long serviceIdentifier = Long.parseLong(serviceId.toString());
                oAuthRegisteredService = (OAuthRegisteredService)this.accessTokenJwtBuilder.getServicesManager().findServiceBy(serviceIdentifier, OAuthRegisteredService.class);
            }
            JWTClaimsSet claims = this.accessTokenJwtBuilder.unpack(Optional.ofNullable(oAuthRegisteredService), tokenId);
            return claims.getJWTID();
        }
        catch (ParseException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return tokenId;
        }
    }

    public String encode(String value, Object[] parameters) {
        OAuthRegisteredService oAuthRegisteredService = (OAuthRegisteredService)this.registeredService;
        if (this.shouldEncodeAsJwt(oAuthRegisteredService, this.accessToken)) {
            JwtBuilder.JwtRequest request = this.getJwtRequestBuilder(Optional.ofNullable(oAuthRegisteredService), this.accessToken);
            return this.accessTokenJwtBuilder.build(request);
        }
        return this.accessToken.getId();
    }

    protected JwtBuilder.JwtRequest getJwtRequestBuilder(Optional<RegisteredService> registeredService, OAuth20AccessToken accessToken) {
        Authentication authentication = accessToken.getAuthentication();
        Principal activePrincipal = this.buildPrincipalForAttributeFilter(accessToken);
        Principal principal = this.profileScopeToAttributesFilter.filter(accessToken.getService(), activePrincipal, registeredService.orElseThrow(), accessToken);
        Map attributes = principal.getAttributes();
        if (accessToken.getAuthentication().containsAttribute("DPoPConfirmation")) {
            CollectionUtils.firstElement(accessToken.getAuthentication().getAttributes().get("DPoPConfirmation")).ifPresent(conf -> {
                JWKThumbprintConfirmation confirmation = new JWKThumbprintConfirmation(new Base64URL(conf.toString()));
                Map.Entry claim = confirmation.toJWTClaim();
                attributes.put((String)claim.getKey(), List.of(claim.getValue()));
            });
        }
        JwtBuilder.JwtRequest.JwtRequestBuilder builder = JwtBuilder.JwtRequest.builder();
        ZonedDateTime dt = authentication.getAuthenticationDate().plusSeconds(accessToken.getExpirationPolicy().getTimeToLive());
        return builder.serviceAudience(accessToken.getClientId()).issueDate(DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate())).jwtId(accessToken.getId()).subject(authentication.getPrincipal().getId()).validUntilDate(DateTimeUtils.dateOf((ChronoZonedDateTime)dt)).attributes(attributes).registeredService(registeredService).issuer((String)StringUtils.defaultIfBlank((CharSequence)this.issuer, (CharSequence)this.casProperties.getServer().getPrefix())).build();
    }

    protected boolean shouldEncodeAsJwt(OAuthRegisteredService oAuthRegisteredService, OAuth20AccessToken accessToken) {
        return this.casProperties.getAuthn().getOauth().getAccessToken().isCreateAsJwt() || oAuthRegisteredService != null && oAuthRegisteredService.isJwtAccessToken() || accessToken.getAuthentication().containsAttribute("DPoP");
    }

    private Principal buildPrincipalForAttributeFilter(OAuth20AccessToken accessToken) {
        Authentication authentication = accessToken.getAuthentication();
        HashMap attributes = new HashMap(authentication.getPrincipal().getAttributes());
        return PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(authentication.getPrincipal().getId(), attributes);
    }

    @Generated
    protected OAuth20JwtAccessTokenEncoder(OAuth20JwtAccessTokenEncoderBuilder<?, ?> b) {
        this.accessTokenJwtBuilder = b.accessTokenJwtBuilder;
        this.accessToken = b.accessToken;
        this.registeredService = b.registeredService;
        this.service = b.service;
        this.casProperties = b.casProperties;
        this.issuer = b.issuer;
        this.profileScopeToAttributesFilter = b.profileScopeToAttributesFilter;
    }

    @Generated
    public static OAuth20JwtAccessTokenEncoderBuilder<?, ?> builder() {
        return new OAuth20JwtAccessTokenEncoderBuilderImpl();
    }

    @Generated
    public JwtBuilder getAccessTokenJwtBuilder() {
        return this.accessTokenJwtBuilder;
    }

    @Generated
    public OAuth20AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public RegisteredService getRegisteredService() {
        return this.registeredService;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public OAuth20ProfileScopeToAttributesFilter getProfileScopeToAttributesFilter() {
        return this.profileScopeToAttributesFilter;
    }

    @Generated
    private static final class OAuth20JwtAccessTokenEncoderBuilderImpl
    extends OAuth20JwtAccessTokenEncoderBuilder<OAuth20JwtAccessTokenEncoder, OAuth20JwtAccessTokenEncoderBuilderImpl> {
        @Generated
        private OAuth20JwtAccessTokenEncoderBuilderImpl() {
        }

        @Override
        @Generated
        protected OAuth20JwtAccessTokenEncoderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OAuth20JwtAccessTokenEncoder build() {
            return new OAuth20JwtAccessTokenEncoder(this);
        }
    }

    @Generated
    public static abstract class OAuth20JwtAccessTokenEncoderBuilder<C extends OAuth20JwtAccessTokenEncoder, B extends OAuth20JwtAccessTokenEncoderBuilder<C, B>> {
        @Generated
        private JwtBuilder accessTokenJwtBuilder;
        @Generated
        private OAuth20AccessToken accessToken;
        @Generated
        private RegisteredService registeredService;
        @Generated
        private Service service;
        @Generated
        private CasConfigurationProperties casProperties;
        @Generated
        private String issuer;
        @Generated
        private OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B accessTokenJwtBuilder(JwtBuilder accessTokenJwtBuilder) {
            this.accessTokenJwtBuilder = accessTokenJwtBuilder;
            return this.self();
        }

        @Generated
        public B accessToken(OAuth20AccessToken accessToken) {
            this.accessToken = accessToken;
            return this.self();
        }

        @Generated
        public B registeredService(RegisteredService registeredService) {
            this.registeredService = registeredService;
            return this.self();
        }

        @Generated
        public B service(Service service) {
            this.service = service;
            return this.self();
        }

        @Generated
        public B casProperties(CasConfigurationProperties casProperties) {
            this.casProperties = casProperties;
            return this.self();
        }

        @Generated
        public B issuer(String issuer) {
            this.issuer = issuer;
            return this.self();
        }

        @Generated
        public B profileScopeToAttributesFilter(OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter) {
            this.profileScopeToAttributesFilter = profileScopeToAttributesFilter;
            return this.self();
        }

        @Generated
        public String toString() {
            return "OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder(accessTokenJwtBuilder=" + this.accessTokenJwtBuilder + ", accessToken=" + this.accessToken + ", registeredService=" + this.registeredService + ", service=" + this.service + ", casProperties=" + this.casProperties + ", issuer=" + this.issuer + ", profileScopeToAttributesFilter=" + this.profileScopeToAttributesFilter + ")";
        }
    }
}

