/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.rest.api.beans.AbstractCSVSpec;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.syncope.common.rest.api.beans.CSVPushSpec;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ConstantReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.KeyValueReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPushExecutor;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.SinglePullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.SinglePushJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.stream.CSVStreamConnector;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamPullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamPushJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.quartz.JobExecutionException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ReconciliationLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final AnyTypeDAO anyTypeDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final RealmDAO realmDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final VirAttrHandler virAttrHandler;
    protected final MappingManager mappingManager;
    protected final InboundMatcher inboundMatcher;
    protected final OutboundMatcher outboundMatcher;
    protected final ConnectorManager connectorManager;

    public ReconciliationLogic(AnyUtilsFactory anyUtilsFactory, AnyTypeDAO anyTypeDAO, ExternalResourceDAO resourceDAO, RealmDAO realmDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, AnySearchDAO anySearchDAO, VirAttrHandler virAttrHandler, MappingManager mappingManager, InboundMatcher inboundMatcher, OutboundMatcher outboundMatcher, ConnectorManager connectorManager) {
        this.anyUtilsFactory = anyUtilsFactory;
        this.anyTypeDAO = anyTypeDAO;
        this.resourceDAO = resourceDAO;
        this.realmDAO = realmDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.anySearchDAO = anySearchDAO;
        this.virAttrHandler = virAttrHandler;
        this.mappingManager = mappingManager;
        this.inboundMatcher = inboundMatcher;
        this.outboundMatcher = outboundMatcher;
        this.connectorManager = connectorManager;
    }

    protected Triple<AnyType, ExternalResource, Provision> getProvision(String anyTypeKey, String resourceKey) {
        AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + anyTypeKey + "'");
        }
        ExternalResource resource = this.resourceDAO.find(resourceKey);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceKey + "'");
        }
        Provision provision = (Provision)resource.getProvisionByAnyType(anyType.getKey()).orElseThrow(() -> new NotFoundException("Provision for " + String.valueOf(anyType) + " on Resource '" + resourceKey + "'"));
        if (provision.getMapping() == null) {
            throw new NotFoundException("Mapping for " + String.valueOf(anyType) + " on Resource '" + resourceKey + "'");
        }
        return Triple.of((Object)anyType, (Object)resource, (Object)provision);
    }

    protected ConnObject getOnSyncope(Item connObjectKeyItem, String connObjectKeyValue, Boolean suspended, Set<Attribute> attrs) {
        ConnObject connObjectTO = ConnObjectUtils.getConnObjectTO(null, attrs);
        connObjectTO.getAttrs().add(new Attr.Builder(connObjectKeyItem.getExtAttrName()).value(connObjectKeyValue).build());
        connObjectTO.getAttrs().add(new Attr.Builder(Uid.NAME).value(connObjectKeyValue).build());
        Optional.ofNullable(suspended).ifPresent(s -> {
            connObjectTO.getAttrs().removeIf(a -> OperationalAttributes.ENABLE_NAME.equals(a.getSchema()));
            connObjectTO.getAttrs().add(new Attr.Builder(OperationalAttributes.ENABLE_NAME).value(BooleanUtils.negate((Boolean)s).toString()).build());
        });
        return connObjectTO;
    }

    protected ConnObject getOnSyncope(Any<?> any, Item connObjectKeyItem, ExternalResource resource, Provision provision) {
        Pair prepared = this.mappingManager.prepareAttrsFromAny(any, null, false, Boolean.valueOf(true), resource, provision);
        return this.getOnSyncope(connObjectKeyItem, (String)prepared.getLeft(), any instanceof User ? ((User)any).isSuspended() : null, (Set)prepared.getRight());
    }

    protected ConnObject getOnSyncope(LinkedAccount account, Item connObjectKeyItem, Provision provision) {
        Set attrs = this.mappingManager.prepareAttrsFromLinkedAccount(account.getOwner(), account, null, false, provision);
        return this.getOnSyncope(connObjectKeyItem, account.getConnObjectKeyValue(), account.isSuspended(), attrs);
    }

    protected Any<?> getAny(Provision provision, AnyTypeKind anyTypeKind, String anyKey) {
        AnyDAO dao = this.anyUtilsFactory.getInstance(anyTypeKind).dao();
        String actualKey = anyKey;
        if (!SyncopeConstants.UUID_PATTERN.matcher(anyKey).matches()) {
            actualKey = dao instanceof UserDAO ? ((UserDAO)dao).findKey(anyKey) : (dao instanceof GroupDAO ? ((GroupDAO)dao).findKey(anyKey) : ((AnyObjectDAO)dao).findKey(provision.getAnyType(), anyKey));
        }
        return Optional.ofNullable(dao.authFind(actualKey)).orElseThrow(() -> new NotFoundException(provision.getAnyType() + " '" + anyKey + "'"));
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    public ReconStatus status(String anyTypeKey, String resourceKey, String anyKey, Set<String> moreAttrsToGet) {
        Triple<AnyType, ExternalResource, Provision> triple = this.getProvision(anyTypeKey, resourceKey);
        Item connObjectKeyItem = (Item)MappingUtils.getConnObjectKeyItem((Provision)((Provision)triple.getRight())).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + ((AnyType)triple.getLeft()).getKey() + " on resource '" + ((ExternalResource)triple.getMiddle()).getKey() + "'"));
        Any<?> any = this.getAny((Provision)triple.getRight(), ((AnyType)triple.getLeft()).getKind(), anyKey);
        ReconStatus status = new ReconStatus();
        status.setMatchType(MatchType.ANY);
        status.setAnyTypeKind(any.getType().getKind());
        status.setAnyKey(any.getKey());
        status.setRealm(any.getRealm().getFullPath());
        status.setOnSyncope(this.getOnSyncope(any, connObjectKeyItem, (ExternalResource)triple.getMiddle(), (Provision)triple.getRight()));
        List connObjs = this.outboundMatcher.match(this.connectorManager.getConnector((ExternalResource)triple.getMiddle()), any, (ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), Optional.of((String[])moreAttrsToGet.toArray(String[]::new)), new Item[0]);
        if (!connObjs.isEmpty()) {
            status.setOnResource(ConnObjectUtils.getConnObjectTO((String)this.outboundMatcher.getFIQL((ConnectorObject)connObjs.get(0), (ExternalResource)triple.getMiddle(), (Provision)triple.getRight()), (Set)((ConnectorObject)connObjs.get(0)).getAttributes()));
            if (connObjs.size() > 1) {
                LOG.warn("Expected single match, found {}", (Object)connObjs);
            } else {
                this.virAttrHandler.setValues(any, (ConnectorObject)connObjs.get(0));
            }
        }
        return status;
    }

    protected SyncDeltaBuilder syncDeltaBuilder(AnyType anyType, ExternalResource resource, Provision provision, Filter filter, Set<String> moreAttrsToGet) {
        Stream<Item> mapItems = Stream.concat(provision.getMapping().getItems().stream(), this.virSchemaDAO.find(resource.getKey(), anyType.getKey()).stream().map(VirSchema::asLinkingMappingItem));
        OperationOptions options = MappingUtils.buildOperationOptions(mapItems, (String[])((String[])moreAttrsToGet.toArray(String[]::new)));
        final SyncDeltaBuilder syncDeltaBuilder = new SyncDeltaBuilder().setToken(new SyncToken((Object)"")).setDeltaType(SyncDeltaType.CREATE_OR_UPDATE).setObjectClass(new ObjectClass(provision.getObjectClass()));
        this.connectorManager.getConnector(resource).search(syncDeltaBuilder.getObjectClass(), filter, new SearchResultsHandler(){

            public boolean handle(ConnectorObject connObj) {
                syncDeltaBuilder.setObject(connObj);
                return false;
            }

            public void handleResult(SearchResult sr) {
            }
        }, 1, null, List.of(), options);
        return syncDeltaBuilder;
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    public ReconStatus status(String anyTypeKey, String resourceKey, Filter filter, Set<String> moreAttrsToGet) {
        Triple<AnyType, ExternalResource, Provision> triple = this.getProvision(anyTypeKey, resourceKey);
        SyncDeltaBuilder syncDeltaBuilder = this.syncDeltaBuilder((AnyType)triple.getLeft(), (ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), filter, moreAttrsToGet);
        ReconStatus status = new ReconStatus();
        if (syncDeltaBuilder.getObject() != null) {
            Item connObjectKeyItem = (Item)MappingUtils.getConnObjectKeyItem((Provision)((Provision)triple.getRight())).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + ((AnyType)triple.getLeft()).getKey() + " on resource '" + ((ExternalResource)triple.getMiddle()).getKey() + "'"));
            this.inboundMatcher.match(syncDeltaBuilder.build(), (ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), ((AnyType)triple.getLeft()).getKind()).stream().findFirst().ifPresent(match -> {
                if (match.getAny() != null) {
                    status.setMatchType(MatchType.ANY);
                    status.setAnyTypeKind(match.getAny().getType().getKind());
                    status.setAnyKey(match.getAny().getKey());
                    status.setRealm(match.getAny().getRealm().getFullPath());
                    status.setOnSyncope(this.getOnSyncope(match.getAny(), connObjectKeyItem, (ExternalResource)triple.getMiddle(), (Provision)triple.getRight()));
                } else if (match.getLinkedAccount() != null) {
                    status.setMatchType(MatchType.LINKED_ACCOUNT);
                    status.setAnyTypeKind(AnyTypeKind.USER);
                    status.setAnyKey(match.getLinkedAccount().getOwner().getKey());
                    status.setRealm(match.getLinkedAccount().getOwner().getRealm().getFullPath());
                    status.setOnSyncope(this.getOnSyncope(match.getLinkedAccount(), connObjectKeyItem, (Provision)triple.getRight()));
                }
            });
            status.setOnResource(ConnObjectUtils.getConnObjectTO((String)this.outboundMatcher.getFIQL(syncDeltaBuilder.getObject(), (ExternalResource)triple.getMiddle(), (Provision)triple.getRight()), (Set)syncDeltaBuilder.getObject().getAttributes()));
            if (status.getMatchType() == MatchType.ANY && StringUtils.isNotBlank((CharSequence)status.getAnyKey())) {
                this.virAttrHandler.setValues(this.getAny((Provision)triple.getRight(), ((AnyType)triple.getLeft()).getKind(), status.getAnyKey()), syncDeltaBuilder.getObject());
            }
        }
        return status;
    }

    protected SyncopeSinglePushExecutor singlePushExecutor() {
        return (SyncopeSinglePushExecutor)ApplicationContextProvider.getBeanFactory().createBean(SinglePushJobDelegate.class, 1, false);
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> push(String anyTypeKey, String resourceKey, String anyKey, PushTaskTO pushTask) {
        Triple<AnyType, ExternalResource, Provision> triple = this.getProvision(anyTypeKey, resourceKey);
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        try {
            results.addAll(this.singlePushExecutor().push((ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), this.connectorManager.getConnector((ExternalResource)triple.getMiddle()), this.getAny((Provision)triple.getRight(), ((AnyType)triple.getLeft()).getKind(), anyKey), pushTask, AuthContextUtils.getWho()));
            if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
            }
        }
        catch (JobExecutionException e) {
            sce.getElements().add(e.getMessage());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return results;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> push(String anyTypeKey, String resourceKey, Filter filter, Set<String> moreAttrsToGet, PushTaskTO pushTask) {
        Triple<AnyType, ExternalResource, Provision> triple = this.getProvision(anyTypeKey, resourceKey);
        SyncDeltaBuilder syncDeltaBuilder = this.syncDeltaBuilder((AnyType)triple.getLeft(), (ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), filter, moreAttrsToGet);
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        if (syncDeltaBuilder.getObject() != null) {
            this.inboundMatcher.match(syncDeltaBuilder.build(), (ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), ((AnyType)triple.getLeft()).getKind()).stream().findFirst().ifPresent(match -> {
                try {
                    if (match.getMatchTarget() == MatchType.ANY) {
                        results.addAll(this.singlePushExecutor().push((ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), this.connectorManager.getConnector((ExternalResource)triple.getMiddle()), match.getAny(), pushTask, AuthContextUtils.getWho()));
                        if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                            sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
                        }
                    } else {
                        ProvisioningReport result = this.singlePushExecutor().push((ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), this.connectorManager.getConnector((ExternalResource)triple.getMiddle()), match.getLinkedAccount(), pushTask, AuthContextUtils.getWho());
                        if (result.getStatus() == ProvisioningReport.Status.FAILURE) {
                            sce.getElements().add(result.getMessage());
                        } else {
                            results.add(result);
                        }
                    }
                }
                catch (JobExecutionException e) {
                    sce.getElements().add(e.getMessage());
                }
            });
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return results;
    }

    protected List<ProvisioningReport> pull(ExternalResource resource, Provision provision, ReconFilterBuilder reconFilterBuilder, Set<String> moreAttrsToGet, PullTaskTO pullTask) {
        if (pullTask.getDestinationRealm() == null || this.realmDAO.findByFullPath(pullTask.getDestinationRealm()) == null) {
            throw new NotFoundException("Realm " + pullTask.getDestinationRealm());
        }
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        try {
            SyncopeSinglePullExecutor executor = (SyncopeSinglePullExecutor)ApplicationContextProvider.getBeanFactory().createBean(SinglePullJobDelegate.class, 1, false);
            results.addAll(executor.pull(resource, provision, this.connectorManager.getConnector(resource), reconFilterBuilder, moreAttrsToGet, pullTask, AuthContextUtils.getWho()));
            if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
            }
        }
        catch (JobExecutionException e) {
            sce.getElements().add(e.getMessage());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return results;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    @Transactional(noRollbackFor={SyncopeClientException.class})
    public List<ProvisioningReport> pull(String anyTypeKey, String resourceKey, String anyKey, Set<String> moreAttrsToGet, PullTaskTO pullTask) {
        Triple<AnyType, ExternalResource, Provision> triple = this.getProvision(anyTypeKey, resourceKey);
        if (((Provision)triple.getRight()).getMapping().getConnObjectKeyItem().isEmpty()) {
            throw new NotFoundException("ConnObjectKey cannot be determined for mapping " + anyTypeKey);
        }
        Any<?> any = this.getAny((Provision)triple.getRight(), ((AnyType)triple.getLeft()).getKind(), anyKey);
        String connObjectKeyValue = (String)this.mappingManager.getConnObjectKeyValue(any, (ExternalResource)triple.getMiddle(), (Provision)triple.getRight()).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + ((AnyType)triple.getLeft()).getKey() + " on resource '" + ((ExternalResource)triple.getMiddle()).getKey() + "'"));
        return this.pull((ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), (ReconFilterBuilder)new KeyValueReconFilterBuilder(((Item)((Provision)triple.getRight()).getMapping().getConnObjectKeyItem().get()).getExtAttrName(), connObjectKeyValue), moreAttrsToGet, pullTask);
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    @Transactional(noRollbackFor={SyncopeClientException.class})
    public List<ProvisioningReport> pull(String anyTypeKey, String resourceKey, Filter filter, Set<String> moreAttrsToGet, PullTaskTO pullTask) {
        Triple<AnyType, ExternalResource, Provision> triple = this.getProvision(anyTypeKey, resourceKey);
        return this.pull((ExternalResource)triple.getMiddle(), (Provision)triple.getRight(), (ReconFilterBuilder)new ConstantReconFilterBuilder(filter), moreAttrsToGet, pullTask);
    }

    protected CsvSchema.Builder csvSchema(AbstractCSVSpec spec) {
        CsvSchema.Builder schemaBuilder = new CsvSchema.Builder().setUseHeader(true).setColumnSeparator(spec.getColumnSeparator()).setArrayElementSeparator(spec.getArrayElementSeparator()).setQuoteChar(spec.getQuoteChar()).setLineSeparator(spec.getLineSeparator()).setNullValue(spec.getNullValue()).setAllowComments(spec.getAllowComments().booleanValue());
        if (spec.getEscapeChar() != null) {
            schemaBuilder.setEscapeChar(spec.getEscapeChar().charValue());
        }
        return schemaBuilder;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> push(SearchCond searchCond, int page, int size, List<OrderByClause> orderBy, String realm, CSVPushSpec spec, OutputStream os) {
        List list;
        List matching;
        SearchCond effectiveCond;
        String entitlement;
        AnyType anyType = this.anyTypeDAO.find(spec.getAnyTypeKey());
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + spec.getAnyTypeKey() + "'");
        }
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        switch (anyType.getKind()) {
            case GROUP: {
                entitlement = "GROUP_SEARCH";
                break;
            }
            case ANY_OBJECT: {
                entitlement = AnyEntitlement.SEARCH.getFor(anyType.getKey());
                break;
            }
            default: {
                entitlement = "USER_SEARCH";
            }
        }
        Realm base = Optional.ofNullable(this.realmDAO.findByFullPath(realm)).orElseThrow(() -> new NotFoundException("Realm " + realm));
        Set adminRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(entitlement)), (String)realm);
        SearchCond searchCond2 = effectiveCond = searchCond == null ? anyUtils.dao().getAllMatchingCond() : searchCond;
        if (spec.getIgnorePaging().booleanValue()) {
            matching = new ArrayList();
            int count = this.anySearchDAO.count(base, true, adminRealms, effectiveCond, anyType.getKind());
            int pages = count / 500 + 1;
            for (int p = 1; p <= pages; ++p) {
                matching.addAll(this.anySearchDAO.search(base, true, adminRealms, effectiveCond, p, 500, orderBy, anyType.getKind()));
            }
        } else {
            matching = this.anySearchDAO.search(base, true, adminRealms, effectiveCond, page, size, orderBy, anyType.getKind());
        }
        ArrayList columns = new ArrayList();
        spec.getFields().forEach(item -> {
            if (anyUtils.getField(item) == null) {
                LOG.warn("Ignoring invalid field {}", item);
            } else {
                columns.add(item);
            }
        });
        spec.getPlainAttrs().forEach(item -> {
            if (this.plainSchemaDAO.find(item) == null) {
                LOG.warn("Ignoring invalid plain schema {}", item);
            } else {
                columns.add(item);
            }
        });
        spec.getDerAttrs().forEach(item -> {
            if (this.derSchemaDAO.find(item) == null) {
                LOG.warn("Ignoring invalid derived schema {}", item);
            } else {
                columns.add(item);
            }
        });
        spec.getVirAttrs().forEach(item -> {
            if (this.virSchemaDAO.find(item) == null) {
                LOG.warn("Ignoring invalid virtual schema {}", item);
            } else {
                columns.add(item);
            }
        });
        PushTaskTO pushTask = new PushTaskTO();
        pushTask.setMatchingRule(spec.getMatchingRule());
        pushTask.setUnmatchingRule(spec.getUnmatchingRule());
        pushTask.getActions().addAll(spec.getProvisioningActions());
        CSVStreamConnector connector = new CSVStreamConnector(null, spec.getArrayElementSeparator(), this.csvSchema((AbstractCSVSpec)spec), null, os, (String[])columns.toArray(String[]::new));
        try {
            SyncopeStreamPushExecutor executor = (SyncopeStreamPushExecutor)ApplicationContextProvider.getBeanFactory().createBean(StreamPushJobDelegate.class, 1, false);
            list = executor.push(anyType, matching, columns, (Connector)connector, spec.getPropagationActions(), pushTask, AuthContextUtils.getWho());
        }
        catch (Throwable executor) {
            try {
                try {
                    connector.close();
                }
                catch (Throwable throwable) {
                    executor.addSuppressed(throwable);
                }
                throw executor;
            }
            catch (Exception e) {
                LOG.error("Could not push to stream", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        connector.close();
        return list;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    @Transactional(noRollbackFor={SyncopeClientException.class})
    public List<ProvisioningReport> pull(CSVPullSpec spec, InputStream csv) {
        List list;
        AnyType anyType = this.anyTypeDAO.find(spec.getAnyTypeKey());
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + spec.getAnyTypeKey() + "'");
        }
        if (this.realmDAO.findByFullPath(spec.getDestinationRealm()) == null) {
            throw new NotFoundException("Realm " + spec.getDestinationRealm());
        }
        PullTaskTO pullTask = new PullTaskTO();
        pullTask.setDestinationRealm(spec.getDestinationRealm());
        pullTask.setRemediation(spec.getRemediation().booleanValue());
        pullTask.setMatchingRule(spec.getMatchingRule());
        pullTask.setUnmatchingRule(spec.getUnmatchingRule());
        pullTask.getActions().addAll(spec.getProvisioningActions());
        CSVStreamConnector connector = new CSVStreamConnector(spec.getKeyColumn(), spec.getArrayElementSeparator(), this.csvSchema((AbstractCSVSpec)spec), csv, null, new String[0]);
        try {
            List columns = connector.getColumns(spec);
            if (!columns.contains(spec.getKeyColumn())) {
                throw new NotFoundException("Key column '" + spec.getKeyColumn() + "'");
            }
            SyncopeStreamPullExecutor executor = (SyncopeStreamPullExecutor)ApplicationContextProvider.getBeanFactory().createBean(StreamPullJobDelegate.class, 1, false);
            list = executor.pull(anyType, spec.getKeyColumn(), columns, spec.getConflictResolutionAction(), spec.getPullCorrelationRule(), (Connector)connector, pullTask, AuthContextUtils.getWho());
        }
        catch (Throwable columns) {
            try {
                try {
                    connector.close();
                }
                catch (Throwable throwable) {
                    columns.addSuppressed(throwable);
                }
                throw columns;
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Could not pull from stream", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        connector.close();
        return list;
    }

    protected EntityTO resolveReference(Method method, Object ... os) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

