/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.logging;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSessionLoggerOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingSessionLoggerOutput.class);

    public static void printLogNodes(List<ObjectNode> logNodes) {
        LoggingSessionLoggerOutput.printLogNodes(logNodes, "info");
    }

    public static void printLogNodes(List<ObjectNode> logNodes, String logLevel) {
        if (logNodes == null) {
            return;
        }
        StringBuilder logBuilder = new StringBuilder("\n");
        for (ObjectNode logNode : logNodes) {
            logBuilder.append(logNode.get("__timeStamp").asText()).append(": ");
            String scopeType = null;
            if (logNode.has("scopeType") && "bpmn".equals(scopeType = logNode.get("scopeType").asText())) {
                logBuilder.append("(").append(logNode.get("scopeId").asText());
                if (logNode.has("subScopeId")) {
                    logBuilder.append(",").append(logNode.get("subScopeId").asText());
                }
                logBuilder.append(") ");
            }
            logBuilder.append(logNode.get("message").asText());
            if ("bpmn".equals(scopeType)) {
                logBuilder.append(" (processInstanceId: '").append(logNode.get("scopeId").asText());
                if (logNode.has("subScopeId")) {
                    logBuilder.append("', executionId: '").append(logNode.get("subScopeId").asText());
                }
                logBuilder.append("', processDefinitionId: '").append(logNode.get("scopeDefinitionId").asText()).append("'");
            }
            if (logNode.has("elementId")) {
                logBuilder.append(", elementId: '").append(logNode.get("elementId").asText());
                if (logNode.has("elementName")) {
                    logBuilder.append("', elementName: '").append(logNode.get("elementName").asText());
                }
                logBuilder.append("', elementType: '").append(logNode.get("elementType").asText()).append("'");
            }
            logBuilder.append(")\n");
        }
        LoggingSessionLoggerOutput.log(logBuilder.toString(), logLevel);
    }

    protected static void log(String message, String logLevel) {
        if ("info".equalsIgnoreCase(logLevel)) {
            LOGGER.info(message);
        } else if ("error".equalsIgnoreCase(logLevel)) {
            LOGGER.error(message);
        } else if ("warn".equalsIgnoreCase(logLevel)) {
            LOGGER.warn(message);
        } else if ("debug".equalsIgnoreCase(logLevel)) {
            LOGGER.debug(message);
        } else if ("trace".equalsIgnoreCase(logLevel)) {
            LOGGER.trace(message);
        }
    }
}

