/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.support;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.DefaultErrorViewResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;

public class MappedExceptionErrorViewResolver
extends DefaultErrorViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedExceptionErrorViewResolver.class);
    private final Map<Class<? extends Throwable>, ModelAndView> mappings;
    private final Function<ErrorContext, Optional<ModelAndView>> defaultFallback;

    public MappedExceptionErrorViewResolver(ApplicationContext applicationContext, WebProperties.Resources resources, Map<Class<? extends Throwable>, ModelAndView> mappings, Function<ErrorContext, Optional<ModelAndView>> defaultFallback) {
        super(applicationContext, resources);
        this.mappings = Map.copyOf(mappings);
        this.defaultFallback = defaultFallback;
        this.setOrder(100);
    }

    public ModelAndView resolveErrorView(HttpServletRequest request, HttpStatus status, Map<String, Object> map) {
        ErrorContext errorContext = new ErrorContext(request, status, map);
        ModelAndView defaultModelAndView = this.defaultFallback.apply(errorContext).orElseGet(() -> super.resolveErrorView(request, status, map));
        Exception exception = (Exception)request.getAttribute("jakarta.servlet.error.exception");
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        if (exception != null) {
            return this.mappings.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(exception.getClass()) || rootCause != null && ((Class)entry.getKey()).isAssignableFrom(rootCause.getClass())).map(Map.Entry::getValue).peek(mv -> mv.getModelMap().putAll(CollectionUtils.wrap((String)"rootCauseException", (Object)Objects.requireNonNullElse(rootCause, exception)))).findFirst().orElse(defaultModelAndView);
        }
        return defaultModelAndView;
    }

    public record ErrorContext(HttpServletRequest request, HttpStatus status, Map<String, Object> map) {
    }
}

