/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SchemaOperationsEngineDropDbCmd
implements Command<Void> {
    protected final String engineScopeType;

    public SchemaOperationsEngineDropDbCmd(String engineScopeType) {
        this.engineScopeType = engineScopeType;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AbstractEngineConfiguration engineConfiguration = commandContext.getEngineConfigurations().get(this.engineScopeType);
        if (engineConfiguration == null) {
            throw new FlowableIllegalArgumentException("There is no engine configuration for scope " + this.engineScopeType);
        }
        ArrayList<SchemaManager> schemaManagers = new ArrayList<SchemaManager>();
        schemaManagers.add(engineConfiguration.getCommonSchemaManager());
        schemaManagers.add(engineConfiguration.getSchemaManager());
        Map<String, SchemaManager> additionalSchemaManagers = engineConfiguration.getAdditionalSchemaManagers();
        if (additionalSchemaManagers != null) {
            schemaManagers.addAll(additionalSchemaManagers.values());
        }
        ListIterator listIterator = schemaManagers.listIterator(schemaManagers.size());
        while (listIterator.hasPrevious()) {
            SchemaManager schemaManager = (SchemaManager)listIterator.previous();
            try {
                schemaManager.schemaDrop();
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }
}

