/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.repository.token;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.otp.repository.token.BaseOneTimeTokenRepository;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingOneTimeTokenRepository
extends BaseOneTimeTokenRepository<OneTimeToken> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingOneTimeTokenRepository.class);
    private final CasReentrantLock lock = new CasReentrantLock();
    private final Cache<String, Collection<OneTimeToken>> storage;

    @Override
    public void cleanInternal() {
        this.lock.tryLock(__ -> {
            LOGGER.trace("Beginning to clean up the cache storage to remove expiring tokens");
            this.storage.cleanUp();
            LOGGER.debug("Estimated total of [{}] token(s) cached and may be removed in future iterations", (Object)this.storage.estimatedSize());
        });
    }

    @Override
    public OneTimeToken store(OneTimeToken token) {
        token.assignIdIfNecessary();
        if (this.exists(token.getUserId(), token.getToken())) {
            Collection tokens = (Collection)this.storage.getIfPresent((Object)token.getUserId());
            Objects.requireNonNull(tokens).add(token);
            LOGGER.debug("Storing previously used tokens [{}] for user [{}]", (Object)tokens, (Object)token.getUserId());
            this.storage.put((Object)token.getUserId(), (Object)tokens);
        } else {
            ArrayList<OneTimeToken> tokens = new ArrayList<OneTimeToken>(1);
            tokens.add(token);
            LOGGER.debug("Storing new token [{}] for user [{}]", (Object)token, (Object)token.getUserId());
            this.storage.put((Object)token.getUserId(), tokens);
        }
        return token;
    }

    @Override
    public OneTimeToken get(String uid, Integer otp) {
        return (OneTimeToken)this.lock.tryLock(() -> {
            Collection tokens = (Collection)this.storage.getIfPresent((Object)uid);
            LOGGER.debug("Found used tokens [{}]", (Object)tokens);
            if (tokens != null) {
                return tokens.stream().filter(t -> t.getToken().equals(otp)).findFirst().orElse(null);
            }
            return null;
        });
    }

    @Override
    public void remove(String uid, Integer otp) {
        this.lock.tryLock(__ -> {
            ConcurrentMap dataset = this.storage.asMap();
            LOGGER.debug("Locating user [{}] to remove token [{}]", (Object)uid, (Object)otp);
            if (dataset.containsKey(uid)) {
                Collection tokens = (Collection)dataset.get(uid);
                tokens.removeIf(t -> otp.equals(t.getToken()));
                LOGGER.debug("Final collection of tokens for [{}] after removal are [{}]", (Object)uid, (Object)tokens);
                this.storage.put((Object)uid, (Object)tokens);
            }
        });
    }

    @Override
    public void remove(String uid) {
        this.lock.tryLock(__ -> this.storage.invalidate((Object)uid));
    }

    @Override
    public void remove(Integer otp) {
        this.lock.tryLock(__ -> {
            ConcurrentMap dataset = this.storage.asMap();
            dataset.values().forEach(tokens -> tokens.removeIf(t -> otp.equals(t.getToken())));
        });
    }

    @Override
    public void removeAll() {
        this.lock.tryLock(__ -> this.storage.invalidateAll());
    }

    @Override
    public long count(String uid) {
        return ((Integer)this.lock.tryLock(() -> {
            Collection tokens = (Collection)this.storage.getIfPresent((Object)uid);
            LOGGER.debug("Found used tokens [{}]", (Object)tokens);
            if (tokens != null) {
                return tokens.size();
            }
            return 0;
        })).intValue();
    }

    @Override
    public long count() {
        return (Long)this.lock.tryLock(() -> this.storage.estimatedSize());
    }

    @Generated
    public CachingOneTimeTokenRepository(Cache<String, Collection<OneTimeToken>> storage) {
        this.storage = storage;
    }
}

