/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.core.web.session.SessionStorageTypes;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.cookie.PinnableCookieProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPAlgorithmsProperties;
import org.apereo.cas.configuration.model.support.saml.idp.profile.SamlIdPSLOProfileProperties;
import org.apereo.cas.configuration.model.support.saml.idp.profile.SamlIdPSSOProfileProperties;
import org.apereo.cas.configuration.model.support.saml.idp.profile.SamlIdPSSOSimpleSignProfileProperties;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.LogoutRedirectionStrategy;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.pac4j.BrowserWebStorageSessionStore;
import org.apereo.cas.pac4j.TicketRegistrySessionStore;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.SamlIdPDistributedSessionCookieCipherExecutor;
import org.apereo.cas.support.saml.services.SamlIdPServiceRegistry;
import org.apereo.cas.support.saml.services.SamlIdPServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.util.Saml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.HttpServletRequestXMLMessageDecodersMap;
import org.apereo.cas.support.saml.web.idp.profile.SamlIdPInitiatedProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.XMLMessageDecodersMap;
import org.apereo.cas.support.saml.web.idp.profile.artifact.SamlIdPSaml1ArtifactResolutionProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.validate.SamlIdPObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.validate.SamlObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.ecp.ECPSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.query.SamlIdPSaml2AttributeQueryProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlIdPPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlIdPRedirectProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPLogoutResponseObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPProfileSingleLogoutMessageCreator;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPSingleLogoutRedirectionStrategy;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPSingleLogoutServiceMessageHandler;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPPostSimpleSignProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPProfileCallbackHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.UrlDecodingHTTPRedirectDeflateDecoder;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.DefaultSSOSamlHttpRequestExtractor;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPInfoEndpointContributor;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.InternalTicketValidator;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.TicketValidator;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.mgmr.DefaultCasCookieValueManager;
import org.apereo.cas.web.support.mgmr.DefaultCookieSameSitePolicy;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostSimpleSignDecoder;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.soap.soap11.Envelope;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.session.JEESessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.autoconfigure.info.InfoContributorFallback;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpMethod;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAMLIdentityProvider})
@Configuration(value="SamlIdPEndpointsConfiguration", proxyBeanMethods=false)
class SamlIdPEndpointsConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPEndpointsConfiguration.class);
    private static final String SAML_SERVER_SUPPORT_PREFIX = "SamlServerSupport";

    SamlIdPEndpointsConfiguration() {
    }

    @Configuration(value="SamlIdPExecutionContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPExecutionContextConfiguration {
        SamlIdPExecutionContextConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext(@Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="samlIdPCallbackService") Service samlIdPCallbackService, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="samlIdPTicketValidator") TicketValidator samlIdPTicketValidator, @Qualifier(value="ssoSamlHttpRequestExtractor") SSOSamlHttpRequestExtractor ssoSamlHttpRequestExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="samlObjectSignatureValidator") SamlObjectSignatureValidator samlObjectSignatureValidator, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy singleSignOnParticipationStrategy, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, @Qualifier(value="samlIdPLogoutResponseObjectBuilder") Saml20ObjectBuilder samlIdPLogoutResponseObjectBuilder, @Qualifier(value="samlIdPDistributedSessionCookieGenerator") CasCookieBuilder samlIdPDistributedSessionCookieGenerator, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<Response> samlProfileSamlResponseBuilder, @Qualifier(value="samlProfileSamlAttributeQueryFaultResponseBuilder") SamlProfileObjectBuilder<Envelope> samlProfileSamlAttributeQueryFaultResponseBuilder, @Qualifier(value="defaultTicketFactory") TicketFactory defaultTicketFactory, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="ssoPostProfileHandlerDecoders") XMLMessageDecodersMap ssoPostProfileHandlerDecoders) {
            return SamlProfileHandlerConfigurationContext.builder().attributeRepository(attributeRepository).samlMessageDecoders(ssoPostProfileHandlerDecoders).authenticationAttributeReleasePolicy(authenticationAttributeReleasePolicy).samlObjectSigner(samlObjectSigner).ticketFactory(defaultTicketFactory).samlObjectEncrypter(samlObjectEncrypter).authenticationSystemSupport(authenticationSystemSupport).servicesManager(servicesManager).webApplicationServiceFactory(samlIdPServiceFactory).samlRegisteredServiceCachingMetadataResolver(defaultSamlRegisteredServiceCachingMetadataResolver).openSamlConfigBean(openSamlConfigBean).casProperties(casProperties).ticketRegistrySupport(ticketRegistrySupport).singleSignOnParticipationStrategy(singleSignOnParticipationStrategy).logoutResponseBuilder(samlIdPLogoutResponseObjectBuilder).singleLogoutServiceLogoutUrlBuilder(singleLogoutServiceLogoutUrlBuilder).samlObjectSignatureValidator(samlObjectSignatureValidator).samlHttpRequestExtractor(ssoSamlHttpRequestExtractor).responseBuilder(samlProfileSamlResponseBuilder).ticketValidator(samlIdPTicketValidator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).samlDistributedSessionCookieGenerator(samlIdPDistributedSessionCookieGenerator).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer).callbackService(samlIdPCallbackService).samlFaultResponseBuilder(samlProfileSamlAttributeQueryFaultResponseBuilder).build();
        }
    }

    @Configuration(value="SamlIdPEndpointCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPEndpointCoreConfiguration {
        SamlIdPEndpointCoreConfiguration() {
        }

        @ConditionalOnMissingBean(name={"ssoSamlHttpRequestExtractor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SSOSamlHttpRequestExtractor ssoSamlHttpRequestExtractor(@Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new DefaultSSOSamlHttpRequestExtractor(openSamlConfigBean.getParserPool());
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPTicketValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketValidator samlIdPTicketValidator(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy) {
            return new InternalTicketValidator(centralAuthenticationService, samlIdPServiceFactory, authenticationAttributeReleasePolicy, servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebSecurityConfigurer<Void> samlIdPProtocolEndpointConfigurer() {
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(StringUtils.prependIfMissing((String)"/idp", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/idp/profile/SAML1", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/idp/profile/SAML2", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                }
            };
        }

        @ConditionalOnMissingBean(name={"samlIdPDistributedSessionCookieCipherExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CipherExecutor samlIdPDistributedSessionCookieCipherExecutor(CasConfigurationProperties casProperties) {
            SessionStorageTypes type = casProperties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
            return (CipherExecutor)FunctionUtils.doIf((type == SessionStorageTypes.TICKET_REGISTRY ? 1 : 0) != 0, () -> {
                CookieSessionReplicationProperties cookie = casProperties.getAuthn().getSamlIdp().getCore().getSessionReplication().getCookie();
                EncryptionJwtSigningJwtCryptographyProperties crypto = cookie.getCrypto();
                boolean enabled = crypto.isEnabled();
                if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
                    LOGGER.warn("Encryption/Signing is not enabled explicitly in the configuration for cookie [{}], yet signing/encryption keys are defined for operations. CAS will proceed to enable the cookie encryption/signing functionality.", (Object)cookie.getName());
                    enabled = true;
                }
                return enabled ? CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, SamlIdPDistributedSessionCookieCipherExecutor.class) : CipherExecutor.noOp();
            }, CipherExecutor::noOp).get();
        }

        @ConditionalOnMissingBean(name={"samlIdPDistributedSessionCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder samlIdPDistributedSessionCookieGenerator(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, @Qualifier(value="samlIdPDistributedSessionCookieCipherExecutor") CipherExecutor samlIdPDistributedSessionCookieCipherExecutor, CasConfigurationProperties casProperties) {
            CookieSessionReplicationProperties cookie = casProperties.getAuthn().getSamlIdp().getCore().getSessionReplication().getCookie();
            if (StringUtils.isBlank((CharSequence)cookie.getName())) {
                cookie.setName("%s%s".formatted("DISSESSION", SamlIdPEndpointsConfiguration.SAML_SERVER_SUPPORT_PREFIX));
            }
            return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie, (CookieValueManager)new DefaultCasCookieValueManager(samlIdPDistributedSessionCookieCipherExecutor, tenantExtractor, geoLocationService, DefaultCookieSameSitePolicy.INSTANCE, (PinnableCookieProperties)cookie));
        }

        @ConditionalOnMissingBean(name={"samlIdPDistributedSessionStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SessionStore samlIdPDistributedSessionStore(CasConfigurationProperties casProperties, @Qualifier(value="samlIdPDistributedSessionCookieGenerator") CasCookieBuilder samlIdPDistributedSessionCookieGenerator, @Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory) {
            SessionStorageTypes type = casProperties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
            switch (type) {
                case TICKET_REGISTRY: {
                    return new TicketRegistrySessionStore(ticketRegistry, ticketFactory, samlIdPDistributedSessionCookieGenerator);
                }
                case BROWSER_STORAGE: {
                    return new BrowserWebStorageSessionStore(webflowCipherExecutor, "SamlIdPSessionStore");
                }
            }
            JEESessionStore jeeSessionStore = new JEESessionStore();
            jeeSessionStore.setPrefix(SamlIdPEndpointsConfiguration.SAML_SERVER_SUPPORT_PREFIX);
            return jeeSessionStore;
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPInfoEndpointContributor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnEnabledInfoContributor(value="saml-idp", fallback=InfoContributorFallback.DISABLE)
        public InfoContributor samlIdPInfoEndpointContributor(CasConfigurationProperties casProperties) {
            return new SamlIdPInfoEndpointContributor(casProperties);
        }
    }

    @Configuration(value="SamlIdPServicesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPServicesConfiguration {
        SamlIdPServicesConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Service samlIdPCallbackService(@Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, CasConfigurationProperties casProperties) {
            String service = casProperties.getServer().getPrefix().concat("/idp/profile/SAML2/Callback");
            return samlIdPServiceFactory.createService(service);
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPServiceRegistryExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceRegistryExecutionPlanConfigurer samlIdPServiceRegistryExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="samlIdPCallbackService") Service samlIdPCallbackService) {
            return plan -> {
                String callbackService = samlIdPCallbackService.getId().concat(".*");
                LOGGER.debug("Initializing SAML IdP callback service [{}]", (Object)callbackService);
                CasRegisteredService service = new CasRegisteredService();
                service.setEvaluationOrder(Integer.MIN_VALUE);
                service.setName(service.getClass().getSimpleName());
                service.setDescription("SAML2 Authentication Request Callback");
                service.setServiceId(callbackService);
                service.markAsInternal();
                plan.registerServiceRegistry((ServiceRegistry)new SamlIdPServiceRegistry(applicationContext, new RegisteredService[]{service}));
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPServicesManagerRegisteredServiceLocator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServicesManagerRegisteredServiceLocator samlIdPServicesManagerRegisteredServiceLocator(@Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver) {
            return new SamlIdPServicesManagerRegisteredServiceLocator(defaultSamlRegisteredServiceCachingMetadataResolver);
        }
    }

    @Configuration(value="SamlIdPEndpointsLogoutExecutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPEndpointsLogoutExecutionConfiguration {
        SamlIdPEndpointsLogoutExecutionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casSamlIdPLogoutExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LogoutExecutionPlanConfigurer casSamlIdPLogoutExecutionPlanConfigurer(@Qualifier(value="samlIdPSingleLogoutRedirectionStrategy") LogoutRedirectionStrategy samlIdPSingleLogoutRedirectionStrategy, @Qualifier(value="samlSingleLogoutServiceMessageHandler") SingleLogoutServiceMessageHandler samlSingleLogoutServiceMessageHandler) {
            return plan -> {
                plan.registerLogoutRedirectionStrategy(samlIdPSingleLogoutRedirectionStrategy);
                plan.registerSingleLogoutServiceMessageHandler(samlSingleLogoutServiceMessageHandler);
            };
        }
    }

    @Configuration(value="SamlIdPEndpointLogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPEndpointLogoutConfiguration {
        SamlIdPEndpointLogoutConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlLogoutBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutMessageCreator samlLogoutBuilder(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner) {
            return new SamlIdPProfileSingleLogoutMessageCreator(openSamlConfigBean, servicesManager, defaultSamlRegisteredServiceCachingMetadataResolver, casProperties.getAuthn().getSamlIdp(), samlObjectSigner);
        }

        @ConditionalOnMissingBean(name={"samlSingleLogoutServiceMessageHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceMessageHandler samlSingleLogoutServiceMessageHandler(CasConfigurationProperties casProperties, @Qualifier(value="samlLogoutBuilder") SingleLogoutMessageCreator samlLogoutBuilder, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, @Qualifier(value="httpClient") HttpClient httpClient, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver) {
            return new SamlIdPSingleLogoutServiceMessageHandler(httpClient, samlLogoutBuilder, servicesManager, singleLogoutServiceLogoutUrlBuilder, casProperties.getSlo().isAsynchronous(), authenticationServiceSelectionPlan, defaultSamlRegisteredServiceCachingMetadataResolver, velocityEngineFactory, openSamlConfigBean);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Saml20ObjectBuilder samlIdPLogoutResponseObjectBuilder(@Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlIdPLogoutResponseObjectBuilder(openSamlConfigBean);
        }
    }

    @Configuration(value="SamlIdPEndpointsLogoutResponseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPEndpointsLogoutResponseConfiguration {
        SamlIdPEndpointsLogoutResponseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlIdPSingleLogoutRedirectionStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LogoutRedirectionStrategy samlIdPSingleLogoutRedirectionStrategy(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
            return new SamlIdPSingleLogoutRedirectionStrategy(samlProfileHandlerConfigurationContext);
        }
    }

    @Configuration(value="SamlIdPEndpointDecoderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPEndpointDecoderConfiguration {
        SamlIdPEndpointDecoderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"ssoPostProfileHandlerDecoders"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public XMLMessageDecodersMap ssoPostProfileHandlerDecoders(CasConfigurationProperties casProperties) {
            SamlIdPSSOProfileProperties props = casProperties.getAuthn().getSamlIdp().getProfile().getSso();
            HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap();
            decoders.put((Object)HttpMethod.GET, (Object)new UrlDecodingHTTPRedirectDeflateDecoder(props.isUrlDecodeRedirectRequest()));
            decoders.put((Object)HttpMethod.POST, (Object)new HTTPPostDecoder());
            return decoders;
        }

        @Bean
        @ConditionalOnMissingBean(name={"ssoPostSimpleSignProfileHandlerDecoders"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public XMLMessageDecodersMap ssoPostSimpleSignProfileHandlerDecoders(CasConfigurationProperties casProperties) {
            SamlIdPSSOSimpleSignProfileProperties props = casProperties.getAuthn().getSamlIdp().getProfile().getSsoPostSimpleSign();
            HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap();
            decoders.put((Object)HttpMethod.GET, (Object)new UrlDecodingHTTPRedirectDeflateDecoder(props.isUrlDecodeRedirectRequest()));
            decoders.put((Object)HttpMethod.POST, (Object)new HTTPPostSimpleSignDecoder());
            return decoders;
        }

        @Bean
        @ConditionalOnMissingBean(name={"sloRedirectProfileHandlerDecoders"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public XMLMessageDecodersMap sloRedirectProfileHandlerDecoders(CasConfigurationProperties casProperties) {
            SamlIdPSLOProfileProperties props = casProperties.getAuthn().getSamlIdp().getProfile().getSlo();
            HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap();
            decoders.put((Object)HttpMethod.GET, (Object)new UrlDecodingHTTPRedirectDeflateDecoder(props.isUrlDecodeRedirectRequest()));
            return decoders;
        }

        @Bean
        @ConditionalOnMissingBean(name={"sloPostProfileHandlerDecoders"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public XMLMessageDecodersMap sloPostProfileHandlerDecoders() {
            HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap();
            decoders.put((Object)HttpMethod.POST, (Object)new HTTPPostDecoder());
            return decoders;
        }
    }

    @Configuration(value="SamlIdPEndpointControllersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPEndpointControllersConfiguration {
        SamlIdPEndpointControllersConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SSOSamlIdPPostProfileHandlerController ssoPostProfileHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
            return new SSOSamlIdPPostProfileHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SSOSamlIdPPostSimpleSignProfileHandlerController ssoPostSimpleSignProfileHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext, @Qualifier(value="ssoPostSimpleSignProfileHandlerDecoders") XMLMessageDecodersMap ssoPostSimpleSignProfileHandlerDecoders) {
            samlProfileHandlerConfigurationContext.setSamlMessageDecoders(ssoPostSimpleSignProfileHandlerDecoders);
            return new SSOSamlIdPPostSimpleSignProfileHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SLOSamlIdPRedirectProfileHandlerController sloRedirectProfileHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext, @Qualifier(value="sloRedirectProfileHandlerDecoders") XMLMessageDecodersMap sloRedirectProfileHandlerDecoders) {
            samlProfileHandlerConfigurationContext.setSamlMessageDecoders(sloRedirectProfileHandlerDecoders);
            return new SLOSamlIdPRedirectProfileHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SLOSamlIdPPostProfileHandlerController sloPostProfileHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext, @Qualifier(value="sloPostProfileHandlerDecoders") XMLMessageDecodersMap sloPostProfileHandlerDecoders) {
            samlProfileHandlerConfigurationContext.setSamlMessageDecoders(sloPostProfileHandlerDecoders);
            return new SLOSamlIdPPostProfileHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPInitiatedProfileHandlerController idpInitiatedSamlProfileHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext, @Qualifier(value="samlIdPObjectSignatureValidator") SamlObjectSignatureValidator samlObjectSignatureValidator) {
            samlProfileHandlerConfigurationContext.setSamlObjectSignatureValidator(samlObjectSignatureValidator);
            return new SamlIdPInitiatedProfileHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SSOSamlIdPProfileCallbackHandlerController ssoPostProfileCallbackHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
            return new SSOSamlIdPProfileCallbackHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ECPSamlIdPProfileHandlerController ecpProfileHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext, @Qualifier(value="samlProfileSamlSoap11FaultResponseBuilder") SamlProfileObjectBuilder<Envelope> samlProfileSamlSoap11FaultResponseBuilder, @Qualifier(value="samlProfileSamlSoap11ResponseBuilder") SamlProfileObjectBuilder<Envelope> samlProfileSamlSoap11ResponseBuilder) {
            samlProfileHandlerConfigurationContext.setResponseBuilder(samlProfileSamlSoap11ResponseBuilder);
            samlProfileHandlerConfigurationContext.setSamlFaultResponseBuilder(samlProfileSamlSoap11FaultResponseBuilder);
            return new ECPSamlIdPProfileHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPSaml1ArtifactResolutionProfileHandlerController saml1ArtifactResolutionController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext, @Qualifier(value="samlProfileSamlArtifactFaultResponseBuilder") SamlProfileObjectBuilder<Envelope> samlProfileSamlArtifactFaultResponseBuilder, @Qualifier(value="samlProfileSamlArtifactResponseBuilder") SamlProfileObjectBuilder<Envelope> samlProfileSamlArtifactResponseBuilder) {
            samlProfileHandlerConfigurationContext.setSamlFaultResponseBuilder(samlProfileSamlArtifactFaultResponseBuilder);
            samlProfileHandlerConfigurationContext.setResponseBuilder(samlProfileSamlArtifactResponseBuilder);
            return new SamlIdPSaml1ArtifactResolutionProfileHandlerController(samlProfileHandlerConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPSaml2AttributeQueryProfileHandlerController saml2AttributeQueryProfileHandlerController(@Qualifier(value="samlProfileHandlerConfigurationContext") SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext, @Qualifier(value="samlProfileSamlAttributeQueryResponseBuilder") SamlProfileObjectBuilder<Envelope> samlProfileSamlAttributeQueryResponseBuilder) {
            samlProfileHandlerConfigurationContext.setResponseBuilder(samlProfileSamlAttributeQueryResponseBuilder);
            return new SamlIdPSaml2AttributeQueryProfileHandlerController(samlProfileHandlerConfigurationContext);
        }
    }

    @Configuration(value="SamlIdPEndpointCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPEndpointCryptoConfiguration {
        SamlIdPEndpointCryptoConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlIdPObjectSignatureValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlObjectSignatureValidator samlIdPObjectSignatureValidator(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver) {
            SamlIdPAlgorithmsProperties algs = casProperties.getAuthn().getSamlIdp().getAlgs();
            return new SamlIdPObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlockedSignatureSigningAlgorithms(), algs.getOverrideAllowedSignatureSigningAlgorithms(), casSamlIdPMetadataResolver, casProperties);
        }

        @ConditionalOnMissingBean(name={"samlObjectSignatureValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlObjectSignatureValidator samlObjectSignatureValidator(CasConfigurationProperties casProperties) {
            SamlIdPAlgorithmsProperties algs = casProperties.getAuthn().getSamlIdp().getAlgs();
            return new SamlObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlockedSignatureSigningAlgorithms(), algs.getOverrideAllowedSignatureSigningAlgorithms(), casProperties);
        }
    }
}

