/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;

public class ConfigurationPropertiesImpl
implements ConfigurationProperties {
    private static final String MSG = "Property ''{0}'' does not exist.";
    private Map<String, ConfigurationPropertyImpl> properties;
    private transient APIConfigurationImpl parent;

    public APIConfigurationImpl getParent() {
        return this.parent;
    }

    public void setParent(APIConfigurationImpl parent) {
        this.parent = parent;
    }

    public void setProperties(Collection<ConfigurationPropertyImpl> in) {
        List<ConfigurationPropertyImpl> props = in.stream().sorted(Comparator.comparing(ConfigurationPropertyImpl::getOrder)).collect(Collectors.toList());
        LinkedHashMap<String, ConfigurationPropertyImpl> temp = new LinkedHashMap<String, ConfigurationPropertyImpl>();
        props.forEach(prop -> {
            temp.put(prop.getName(), (ConfigurationPropertyImpl)prop);
            prop.setParent(this);
        });
        this.properties = temp;
    }

    public Collection<ConfigurationPropertyImpl> getProperties() {
        return this.properties.values();
    }

    public ConfigurationProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>(this.properties.keySet());
        return CollectionUtil.newReadOnlyList(names);
    }

    public void setPropertyValue(String name, Object value) {
        ConfigurationPropertyImpl property = Optional.ofNullable(this.properties.get(name)).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format(MSG, name)));
        property.setValue(value);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigurationPropertiesImpl) {
            ConfigurationPropertiesImpl other = (ConfigurationPropertiesImpl)o;
            HashSet<ConfigurationPropertyImpl> set1 = new HashSet<ConfigurationPropertyImpl>(this.properties.values());
            HashSet<ConfigurationPropertyImpl> set2 = new HashSet<ConfigurationPropertyImpl>(other.properties.values());
            return set1.equals(set2);
        }
        return false;
    }

    public int hashCode() {
        HashSet<ConfigurationPropertyImpl> set1 = new HashSet<ConfigurationPropertyImpl>(this.properties.values());
        return set1.hashCode();
    }
}

