/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetadata;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.util.RandomUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;

public final class SecurityContextUtils {
    public static SecurityContext createSecurityContext(TransientSessionTicket transientTicket, HttpServletRequest request) {
        Principal principal = (Principal)transientTicket.getProperty(Principal.class.getName(), Principal.class);
        return SecurityContextUtils.createSecurityContext(principal, request);
    }

    public static SecurityContext createSecurityContext(Principal principal, HttpServletRequest request) {
        List authorities = principal.getAttributes().keySet().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        User user = new User(principal.getId(), RandomUtils.generateSecureRandomId(), authorities);
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)user, (Object)new SecurityContextCredential(principal.getId()), authorities);
        authenticationToken.setAuthenticated(true);
        authenticationToken.setDetails((Object)new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(request, authorities));
        SecurityContextImpl context = new SecurityContextImpl((Authentication)authenticationToken);
        context.setAuthentication((Authentication)authenticationToken);
        return context;
    }

    @Generated
    private SecurityContextUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class SecurityContextCredential
    implements Credential {
        private static final long serialVersionUID = -6075800625583285084L;
        private final String id;
        private CredentialMetadata credentialMetadata;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public CredentialMetadata getCredentialMetadata() {
            return this.credentialMetadata;
        }

        @Generated
        public SecurityContextCredential(String id) {
            this.id = id;
        }
    }
}

