/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconStatusUtils
implements Serializable {
    private static final long serialVersionUID = -5411720003057109354L;
    private static final Logger LOG = LoggerFactory.getLogger(ReconStatusUtils.class);
    protected final ReconciliationRestClient reconciliationRestClient;

    public ReconStatusUtils(ReconciliationRestClient reconciliationRestClient) {
        this.reconciliationRestClient = reconciliationRestClient;
    }

    public Optional<ReconStatus> getReconStatus(String anyTypeKey, String connObjectKeyValue, String resource) {
        ReconStatus result = null;
        try {
            result = this.reconciliationRestClient.status(new ReconQuery.Builder(anyTypeKey, resource).fiql("__UID__==" + connObjectKeyValue).build());
        }
        catch (Exception e) {
            LOG.warn("Unexpected error for {} {} on {}", new Object[]{anyTypeKey, connObjectKeyValue, resource, e});
        }
        return Optional.ofNullable(result);
    }

    public List<Pair<String, ReconStatus>> getReconStatuses(String anyTypeKey, String anyKey, Collection<String> resources) {
        return resources.stream().map(resource -> {
            try {
                return Pair.of((Object)resource, (Object)this.reconciliationRestClient.status(new ReconQuery.Builder(anyTypeKey, resource).anyKey(anyKey).build()));
            }
            catch (Exception e) {
                LOG.warn("Unexpected error for {} {} on {}", new Object[]{anyTypeKey, anyKey, resource, e});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

