/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.view.AbstractCasView;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;

public class Cas10ResponseView
extends AbstractCasView {
    public Cas10ResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CasProtocolAttributesRenderer attributesRenderer, AttributeDefinitionStore attributeDefinitionStore) {
        super(successResponse, protocolAttributeEncoder, servicesManager, authenticationAttributeReleasePolicy, serviceSelectionStrategy, attributesRenderer, attributeDefinitionStore);
    }

    protected void renderMergedOutputModel(@Nonnull Map model, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws Exception {
        try (StringWriter writer = new StringWriter();){
            if (this.successResponse) {
                this.prepareViewModelWithAuthenticationPrincipal(model);
                this.prepareCasResponseAttributesForViewModel(model);
                writer.write("yes\n" + this.getPrimaryAuthenticationFrom(model).getPrincipal().getId() + "\n");
                if (model.containsKey("formattedAttributes")) {
                    Collection attributes = (Collection)model.get("formattedAttributes");
                    attributes.forEach(attr -> {
                        writer.write(attr.toString());
                        writer.write(10);
                    });
                }
            } else {
                writer.write("no\n\n");
            }
            String message = writer.toString();
            LoggingUtils.protocolMessage((String)"CAS v1 Response", Map.of(), (Object)message);
            response.setContentType("text/plain");
            response.getWriter().write(message);
        }
    }
}

