/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import java.util.Map;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.settings.DebugSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public class RadioChoice<T>
extends AbstractSingleSelectChoice<T> {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String suffix = "";
    private AbstractChoice.LabelPosition labelPosition = AbstractChoice.LabelPosition.AFTER;

    public RadioChoice(String id) {
        super(id);
    }

    public RadioChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public RadioChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public RadioChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public RadioChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public RadioChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public RadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public RadioChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public RadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("name");
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected String getPrefix(int index, T choice) {
        return this.getPrefix();
    }

    protected String getSuffix(int index, T choice) {
        return this.getSuffix();
    }

    public final RadioChoice<T> setPrefix(String prefix) {
        this.addStateChange();
        this.prefix = prefix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public final RadioChoice<T> setSuffix(String suffix) {
        this.addStateChange();
        this.suffix = suffix;
        return this;
    }

    public RadioChoice<T> setLabelPosition(AbstractChoice.LabelPosition labelPosition) {
        Args.notNull((Object)((Object)labelPosition), (String)"labelPosition");
        this.labelPosition = labelPosition;
        return this;
    }

    @Override
    protected CharSequence getDefaultChoice(String selectedValue) {
        return "";
    }

    @Override
    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice, int index, String selected) {
        DebugSettings debugSettings;
        String componentPathAttributeName;
        buffer.append(this.getPrefix(index, choice));
        String id = this.getChoiceRenderer().getIdValue(choice, index);
        String idAttr = this.getMarkupId() + "-" + id;
        boolean enabled = this.isEnabledInHierarchy() && !this.isDisabled(choice, index, selected);
        CharSequence renderValue = this.renderValue(choice);
        IValueMap labelAttrs = this.getAdditionalAttributesForLabel(index, choice);
        StringBuilder extraLabelAttributes = new StringBuilder();
        if (labelAttrs != null) {
            for (Object attr : labelAttrs.entrySet()) {
                extraLabelAttributes.append(' ').append(Strings.escapeMarkup((CharSequence)((CharSequence)attr.getKey()))).append("=\"").append(Strings.escapeMarkup((CharSequence)attr.getValue().toString())).append('\"');
            }
        }
        this.labelPosition.before(buffer, idAttr, extraLabelAttributes, renderValue);
        buffer.append("<input name=\"").append(this.getInputName()).append('\"').append(" type=\"radio\"").append(this.isSelected(choice, index, selected) ? " checked=\"checked\"" : "").append(enabled ? "" : " disabled=\"disabled\"").append(" value=\"").append((Object)Strings.escapeMarkup((CharSequence)id)).append("\" id=\"").append((Object)Strings.escapeMarkup((CharSequence)idAttr)).append('\"');
        IValueMap attrs = this.getAdditionalAttributes(index, choice);
        if (attrs != null) {
            for (Map.Entry attr : attrs.entrySet()) {
                buffer.append(' ').append((Object)Strings.escapeMarkup((CharSequence)((CharSequence)attr.getKey()))).append("=\"").append((Object)Strings.escapeMarkup((CharSequence)attr.getValue().toString())).append('\"');
            }
        }
        if (!Strings.isEmpty((String)(componentPathAttributeName = (debugSettings = this.getApplication().getDebugSettings()).getComponentPathAttributeName()))) {
            CharSequence path = this.getPageRelativePath();
            path = Strings.replaceAll((CharSequence)path, (CharSequence)"_", (CharSequence)"__");
            path = Strings.replaceAll((CharSequence)path, (CharSequence)":", (CharSequence)"_");
            buffer.append(' ').append(componentPathAttributeName).append("=\"").append((Object)path).append("_input_").append(index).append('\"');
        }
        buffer.append("/>");
        this.labelPosition.after(buffer, idAttr, extraLabelAttributes, renderValue);
        buffer.append(this.getSuffix(index, choice));
    }

    protected IValueMap getAdditionalAttributesForLabel(int index, T choice) {
        return null;
    }

    protected IValueMap getAdditionalAttributes(int index, T choice) {
        return null;
    }
}

