/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.common.rest.api.beans.TaskQuery;
import org.apache.syncope.common.rest.api.service.ExecutableService;

@Tag(name="Tasks")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="tasks")
public interface TaskService
extends ExecutableService {
    @GET
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public <T extends TaskTO> T read(@NotNull @PathParam(value="type") TaskType var1, @NotNull @PathParam(value="key") String var2, @QueryParam(value="details") @DefaultValue(value="true") boolean var3);

    @GET
    @Path(value="{type}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public <T extends TaskTO> PagedResult<T> search(@BeanParam TaskQuery var1);

    @ApiResponses(value={@ApiResponse(responseCode="201", description="Task successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Path(value="{type}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull @PathParam(value="type") TaskType var1, @NotNull SchedTaskTO var2);

    @Parameter(name="key", description="Task's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull @PathParam(value="type") TaskType var1, @NotNull SchedTaskTO var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="type") TaskType var1, @NotNull @PathParam(value="key") String var2);

    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of deleted propagation tasks, as Entity"), @ApiResponse(responseCode="412", description="At least one matching condition must be specified")})
    @DELETE
    @Path(value="PROPAGATION/purge")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response purgePropagations(@QueryParam(value="since") OffsetDateTime var1, @QueryParam(value="statuses") List<ExecStatus> var2, @QueryParam(value="resources") List<String> var3);

    @GET
    @Path(value="MACRO/{key}/form")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public SyncopeForm getMacroTaskForm(@NotNull @PathParam(value="key") String var1, @NotNull @QueryParam(value="locale") String var2);

    @POST
    @Path(value="MACRO/{key}/execute")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ExecTO execute(@BeanParam ExecSpecs var1, SyncopeForm var2);
}

