/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import kafka.utils.Json$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.security.authorizer.AclEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U2A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!9\u0001\u0004\u0001b\u0001\n\u0003I\u0002B\u0002\u0012\u0001A\u0003%!\u0004C\u0003$\u0001\u0011\u0005AE\u0001\u0007BG2,e\u000e\u001e:z)\u0016\u001cHO\u0003\u0002\b\u0011\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005%Q\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0011\u0005]\u0001Q\"\u0001\u0004\u0002\u000f\u0005\u001bGNS:p]V\t!\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\rM#(/\u001b8h\u0003!\t5\r\u001c&t_:\u0004\u0013!\u0006;fgR\f5\r\u001c&t_:\u001cuN\u001c<feNLwN\u001c\u000b\u0002KA\u0011qBJ\u0005\u0003OA\u0011A!\u00168ji\"\u0012A!\u000b\t\u0003UMj\u0011a\u000b\u0006\u0003Y5\n1!\u00199j\u0015\tqs&A\u0004kkBLG/\u001a:\u000b\u0005A\n\u0014!\u00026v]&$(\"\u0001\u001a\u0002\u0007=\u0014x-\u0003\u00025W\t!A+Z:u\u0001")
public class AclEntryTest {
    private final String AclJson;

    public String AclJson() {
        return this.AclJson;
    }

    @Test
    public void testAclJsonConversion() {
        AclEntry acl1 = new AclEntry(new AccessControlEntry(new KafkaPrincipal("User", "alice").toString(), "host1", AclOperation.READ, AclPermissionType.DENY));
        AclEntry acl2 = new AclEntry(new AccessControlEntry(new KafkaPrincipal("User", "bob").toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclEntry acl3 = new AclEntry(new AccessControlEntry(new KafkaPrincipal("User", "bob").toString(), "host1", AclOperation.READ, AclPermissionType.DENY));
        HashSet<AclEntry> acls = new HashSet<AclEntry>(Arrays.asList(acl1, acl2, acl3));
        Assertions.assertEquals(acls, (Object)AclEntry.fromBytes((byte[])Json$.MODULE$.encodeAsBytes((Object)AclEntry.toJsonCompatibleMap(acls))));
        Assertions.assertEquals(acls, (Object)AclEntry.fromBytes((byte[])this.AclJson().getBytes(StandardCharsets.UTF_8)));
    }

    public AclEntryTest() {
        this.AclJson = "{\"version\": 1, \"acls\": [{\"host\": \"host1\",\"permissionType\": \"Deny\",\"operation\": \"READ\", \"principal\": \"User:alice\"  },\n    {  \"host\":  \"*\" ,  \"permissionType\": \"Allow\",  \"operation\":  \"Read\", \"principal\": \"User:bob\"  },\n    {  \"host\": \"host1\",  \"permissionType\": \"Deny\",  \"operation\":   \"Read\" ,  \"principal\": \"User:bob\"}]}";
    }
}

