/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.internal.util;

import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class OptionalUtil {
    public static <T> Optional<T> orOptional(Optional<T> primary, Optional<T> secondary) {
        if (primary.isPresent()) {
            return primary;
        }
        return secondary;
    }

    public static <T> Optional<T> orElseOptional(Optional<T> primary, Supplier<Optional<T>> recover) {
        if (primary.isPresent()) {
            return primary;
        }
        return recover.get();
    }

    public static <T> Stream<T> stream(@NonNull Optional<T> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Optional<T> zipWith(Optional<T> a, Optional<T> b, BinaryOperator<T> f) {
        if (a.isPresent() && b.isPresent()) {
            return Optional.of(f.apply(a.get(), b.get()));
        }
        if (a.isPresent()) {
            return a;
        }
        return b;
    }

    @Generated
    private OptionalUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

