/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.util.Collection;
import java.util.List;
import org.apache.syncope.common.lib.wa.WebAuthnAccount;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class WebAuthnRegistrationLogic
extends AbstractAuthProfileLogic {
    public WebAuthnRegistrationLogic(AuthProfileDataBinder binder, AuthProfileDAO authProfileDAO, EntityFactory entityFactory) {
        super(binder, authProfileDAO, entityFactory);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<WebAuthnAccount> list() {
        return this.authProfileDAO.findAll(Pageable.unpaged()).stream().map(profile -> new WebAuthnAccount.Builder().credentials((Collection)profile.getWebAuthnDeviceCredentials()).build()).toList();
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public WebAuthnAccount read(String owner) {
        return this.authProfileDAO.findByOwner(owner).stream().findFirst().map(profile -> new WebAuthnAccount.Builder().credentials((Collection)profile.getWebAuthnDeviceCredentials()).build()).orElseThrow(() -> new NotFoundException("Could not find account for Owner " + owner));
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(String owner) {
        this.authProfileDAO.findByOwner(owner).ifPresent(profile -> {
            profile.setWebAuthnDeviceCredentials(List.of());
            this.authProfileDAO.save((Entity)profile);
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(String owner, String credentialId) {
        this.authProfileDAO.findByOwner(owner).stream().findFirst().ifPresent(profile -> {
            List credentials = profile.getWebAuthnDeviceCredentials();
            if (credentials.removeIf(acct -> acct.getIdentifier().equals(credentialId))) {
                profile.setWebAuthnDeviceCredentials(credentials);
                this.authProfileDAO.save((Entity)profile);
            }
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void create(String owner, WebAuthnAccount account) {
        AuthProfile profile = this.authProfile(owner);
        profile.setWebAuthnDeviceCredentials(account.getCredentials());
        this.authProfileDAO.save((Entity)profile);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void update(String owner, WebAuthnAccount account) {
        this.authProfileDAO.findByOwner(owner).ifPresent(profile -> {
            profile.setWebAuthnDeviceCredentials(account.getCredentials());
            this.authProfileDAO.save((Entity)profile);
        });
    }
}

