/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ldaptive.AbstractMessage;
import org.ldaptive.AbstractResult;
import org.ldaptive.Freezable;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchResultReference;
import org.ldaptive.asn1.DERBuffer;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.dn.Dn;

public final class SearchResponse
extends AbstractResult
implements Freezable {
    public static final int PROTOCOL_OP = 5;
    private static final int HASH_CODE_SEED = 10301;
    private static final DERPath RESULT_CODE_PATH = new DERPath("/SEQ/APP(5)/ENUM[0]");
    private static final DERPath MATCHED_DN_PATH = new DERPath("/SEQ/APP(5)/OCTSTR[1]");
    private static final DERPath DIAGNOSTIC_MESSAGE_PATH = new DERPath("/SEQ/APP(5)/OCTSTR[2]");
    private static final DERPath REFERRAL_PATH = new DERPath("/SEQ/APP(5)/CTX(3)/OCTSTR[0]");
    private final List<LdapEntry> resultEntries = new ArrayList<LdapEntry>();
    private final List<SearchResultReference> resultReferences = new ArrayList<SearchResultReference>();
    private volatile boolean immutable;

    public SearchResponse() {
    }

    public SearchResponse(DERBuffer buffer) {
        DERParser parser = new DERParser();
        parser.registerHandler(AbstractMessage.MessageIDHandler.PATH, new AbstractMessage.MessageIDHandler(this));
        parser.registerHandler(RESULT_CODE_PATH, new AbstractResult.ResultCodeHandler(this));
        parser.registerHandler(MATCHED_DN_PATH, new AbstractResult.MatchedDNHandler(this));
        parser.registerHandler(DIAGNOSTIC_MESSAGE_PATH, new AbstractResult.DiagnosticMessageHandler(this));
        parser.registerHandler(REFERRAL_PATH, new AbstractResult.ReferralHandler(this));
        parser.registerHandler(AbstractMessage.ControlsHandler.PATH, new AbstractMessage.ControlsHandler(this));
        parser.parse(buffer);
    }

    @Override
    public void freeze() {
        this.immutable = true;
        this.resultEntries.forEach(LdapEntry::freeze);
        this.resultReferences.forEach(SearchResultReference::freeze);
    }

    @Override
    public boolean isFrozen() {
        return this.immutable;
    }

    @Override
    public void assertMutable() {
        if (this.immutable) {
            throw new IllegalStateException("Cannot modify immutable object");
        }
    }

    public Collection<LdapEntry> getEntries() {
        return this.immutable ? Collections.unmodifiableCollection(this.resultEntries) : this.resultEntries;
    }

    public LdapEntry getEntry() {
        if (this.resultEntries.isEmpty()) {
            return null;
        }
        return this.resultEntries.iterator().next();
    }

    public LdapEntry getEntry(String dn) {
        String compareDn = new Dn(dn).format();
        return this.resultEntries.stream().filter(e -> compareDn.equals(e.getNormalizedDn())).findAny().orElse(null);
    }

    public Collection<String> getEntryDns() {
        return this.resultEntries.stream().map(LdapEntry::getDn).collect(Collectors.toUnmodifiableList());
    }

    public void addEntries(LdapEntry ... entry) {
        this.assertMutable();
        Collections.addAll(this.resultEntries, entry);
    }

    public void addEntries(Collection<LdapEntry> entries) {
        this.assertMutable();
        this.resultEntries.addAll(entries);
    }

    public void removeEntries(LdapEntry ... entry) {
        this.assertMutable();
        for (LdapEntry e : entry) {
            this.resultEntries.remove(e);
        }
    }

    public void removeEntries(Collection<LdapEntry> entries) {
        this.assertMutable();
        entries.forEach(this.resultEntries::remove);
    }

    public int entrySize() {
        return this.resultEntries.size();
    }

    public Collection<SearchResultReference> getReferences() {
        return this.immutable ? Collections.unmodifiableCollection(this.resultReferences) : this.resultReferences;
    }

    public SearchResultReference getReference() {
        if (this.resultReferences.isEmpty()) {
            return null;
        }
        return this.resultReferences.iterator().next();
    }

    public void addReferences(SearchResultReference ... reference) {
        this.assertMutable();
        Collections.addAll(this.resultReferences, reference);
    }

    public void addReferences(Collection<SearchResultReference> references) {
        this.assertMutable();
        this.resultReferences.addAll(references);
    }

    public void removeReferences(SearchResultReference ... reference) {
        this.assertMutable();
        for (SearchResultReference r : reference) {
            this.resultReferences.remove(r);
        }
    }

    public void removeReferences(Collection<SearchResultReference> references) {
        this.assertMutable();
        references.forEach(this.resultReferences::remove);
    }

    public int referenceSize() {
        return this.resultReferences.size();
    }

    public SearchResponse subResult(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.resultEntries.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Illegal index value");
        }
        SearchResponse result = new SearchResponse();
        if (this.resultEntries.isEmpty() || fromIndex == toIndex) {
            return result;
        }
        int i = 0;
        for (LdapEntry e : this.resultEntries) {
            if (i >= fromIndex && i < toIndex) {
                result.addEntries(e);
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SearchResponse && super.equals(o)) {
            SearchResponse v = (SearchResponse)o;
            return LdapUtils.areEqual(this.resultEntries, v.resultEntries) && LdapUtils.areEqual(this.resultReferences, v.resultReferences);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(10301, new Object[]{this.getMessageID(), this.getControls(), this.getResultCode(), this.getMatchedDN(), this.getDiagnosticMessage(), this.getReferralURLs(), this.resultEntries, this.resultReferences});
    }

    @Override
    public String toString() {
        return super.toString() + ", entries=" + this.resultEntries + ", references=" + this.resultReferences;
    }

    public static SearchResponse copy(SearchResponse response) {
        SearchResponse copy = new SearchResponse();
        copy.copyValues(response);
        response.resultEntries.forEach(e -> copy.resultEntries.add(LdapEntry.copy(e)));
        response.resultReferences.forEach(r -> copy.resultReferences.add(SearchResultReference.copy(r)));
        return copy;
    }

    public static SearchResponse sort(SearchResponse result) {
        SearchResponse sorted = new SearchResponse();
        sorted.copyValues(result);
        Set entries = result.getEntries().stream().map(LdapEntry::sort).sorted(Comparator.comparing(LdapEntry::getDn, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toCollection(LinkedHashSet::new));
        sorted.addEntries(entries);
        Set references = result.getReferences().stream().map(SearchResultReference::sort).sorted(Comparator.comparing(SearchResultReference::hashCode)).collect(Collectors.toCollection(LinkedHashSet::new));
        sorted.addReferences(references);
        if (result.isFrozen()) {
            sorted.freeze();
        }
        return sorted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractResult.AbstractBuilder<Builder, SearchResponse> {
        private Builder() {
            super(new SearchResponse());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder freeze() {
            ((SearchResponse)this.object).freeze();
            return this;
        }

        public Builder entry(LdapEntry ... e) {
            ((SearchResponse)this.object).addEntries(e);
            return this;
        }

        public Builder entry(Collection<LdapEntry> entries) {
            ((SearchResponse)this.object).addEntries(entries);
            return this;
        }

        public Builder reference(SearchResultReference ... r) {
            ((SearchResponse)this.object).addReferences(r);
            return this;
        }

        public Builder reference(Collection<SearchResultReference> references) {
            ((SearchResponse)this.object).addReferences(references);
            return this;
        }
    }
}

