/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import jakarta.servlet.ServletException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateHttpServletRequest
extends AbstractConditionalProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateHttpServletRequest.class);
    @NonnullAfterInit
    private HttpServletRequestValidator validator;

    @NonnullAfterInit
    public HttpServletRequestValidator getValidator() {
        return this.validator;
    }

    public void setValidator(@Nullable HttpServletRequestValidator newValidator) {
        this.checkSetterPreconditions();
        this.validator = newValidator;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest was null");
        }
        if (this.getValidator() == null) {
            throw new ComponentInitializationException("HttpServletRequestValidator was null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileContext) {
        try {
            this.getValidator().validate(this.ensureHttpServletRequest());
            ActionSupport.buildProceedEvent((ProfileRequestContext)profileContext);
        }
        catch (ServletException e) {
            this.log.warn("HttpServletRequest failed validation", (Throwable)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)"InvalidMessage");
        }
    }
}

