/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.ui.commons.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.ActionPermissions;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Roles
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 552437609667518888L;
    @SpringBean
    protected RoleRestClient roleRestClient;
    protected final List<String> allRoles;
    protected final UserTO userTO;
    protected WebMarkupContainer dynrolesContainer;

    public <T extends AnyTO> Roles(UserWrapper modelObject) {
        if (modelObject.getPreviousUserTO() != null && !((UserTO)modelObject.getInnerObject()).getRoles().equals(modelObject.getPreviousUserTO().getRoles())) {
            this.add(new Component[]{new LabelInfo("changed", "")});
        } else {
            this.add(new Component[]{new Label("changed", (Serializable)((Object)""))});
        }
        this.userTO = (UserTO)modelObject.getInnerObject();
        ActionPermissions permissions = new ActionPermissions();
        this.setMetaData(MetaDataRoleAuthorizationStrategy.ACTION_PERMISSIONS, (Serializable)permissions);
        permissions.authorize(RENDER, new org.apache.wicket.authroles.authorization.strategies.role.Roles("ROLE_LIST"));
        this.setOutputMarkupId(true);
        this.allRoles = this.getManagedRoles();
        this.add(new Component[]{this.buildRolesSelector(modelObject)});
        this.dynrolesContainer = new WebMarkupContainer("dynrolesContainer");
        this.dynrolesContainer.setOutputMarkupId(true);
        this.dynrolesContainer.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{this.dynrolesContainer});
        this.dynrolesContainer.add(new Component[]{new AjaxPalettePanel.Builder().build("dynroles", (IModel)new PropertyModel((Object)this.userTO, "dynRoles"), (IModel)new ListModel(this.allRoles)).hideLabel().setEnabled(false).setOutputMarkupId(true)});
    }

    protected List<String> getManagedRoles() {
        return SyncopeWebApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER) ? this.roleRestClient.list().stream().map(RoleTO::getKey).sorted().collect(Collectors.toList()) : List.of();
    }

    protected Component buildRolesSelector(UserWrapper modelObject) {
        return new AjaxPalettePanel.Builder().withFilter().setAllowOrder(true).build("roles", (IModel)new PropertyModel((Object)modelObject.getInnerObject(), "roles"), (AjaxPalettePanel.Builder.Query)new AjaxPalettePanel.Builder.Query<String>(){
            private static final long serialVersionUID = 3900199363626636719L;

            public List<String> execute(String filter) {
                if (StringUtils.isEmpty((CharSequence)filter) || "*".equals(filter)) {
                    return Roles.this.allRoles.size() > 30 ? Roles.this.allRoles.subList(0, 30) : Roles.this.allRoles;
                }
                return Roles.this.allRoles.stream().filter(role -> Strings.CI.contains((CharSequence)role, (CharSequence)filter)).collect(Collectors.toList());
            }
        }).hideLabel().setOutputMarkupId(true);
    }

    public final boolean evaluate() {
        return CollectionUtils.isNotEmpty(this.allRoles) && SyncopeWebApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
    }
}

