/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetCommitRequestTest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TxnOffsetCommitRequestTest
extends OffsetCommitRequestTest {
    private static final Map<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> OFFSETS = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
    private static TxnOffsetCommitRequest.Builder builder;
    private static TxnOffsetCommitRequest.Builder builderWithGroupMetadata;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        OFFSETS.clear();
        OFFSETS.put(new TopicPartition(topicOne, partitionOne), new TxnOffsetCommitRequest.CommittedOffset(offset, metadata, Optional.of(Integer.valueOf(leaderEpoch))));
        OFFSETS.put(new TopicPartition(topicTwo, partitionTwo), new TxnOffsetCommitRequest.CommittedOffset(offset, metadata, Optional.of(Integer.valueOf(leaderEpoch))));
        String transactionalId = "transactionalId";
        int producerId = 10;
        short producerEpoch = 1;
        builder = new TxnOffsetCommitRequest.Builder(transactionalId, groupId, (long)producerId, producerEpoch, OFFSETS);
        int generationId = 5;
        builderWithGroupMetadata = new TxnOffsetCommitRequest.Builder(transactionalId, groupId, (long)producerId, producerEpoch, OFFSETS, memberId, generationId, Optional.of(groupInstanceId));
    }

    @Override
    @Test
    public void testConstructor() {
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(new TopicPartition(topicOne, partitionOne), Errors.NOT_COORDINATOR);
        errorsMap.put(new TopicPartition(topicTwo, partitionTwo), Errors.NOT_COORDINATOR);
        List<TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic> expectedTopics = Arrays.asList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicOne).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partitionOne).setCommittedOffset(offset).setCommittedLeaderEpoch((int)leaderEpoch).setCommittedMetadata(metadata))), new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicTwo).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partitionTwo).setCommittedOffset(offset).setCommittedLeaderEpoch((int)leaderEpoch).setCommittedMetadata(metadata))));
        Iterator iterator = ApiKeys.TXN_OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            TxnOffsetCommitRequest request = version < 3 ? builder.build(version) : builderWithGroupMetadata.build(version);
            Assertions.assertEquals(OFFSETS, (Object)request.offsets());
            Assertions.assertEquals(expectedTopics, (Object)TxnOffsetCommitRequest.getTopics((Map)request.offsets()));
            TxnOffsetCommitResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.NOT_COORDINATOR.exception());
            Assertions.assertEquals(errorsMap, (Object)response.errors());
            Assertions.assertEquals(Collections.singletonMap(Errors.NOT_COORDINATOR, 2), (Object)response.errorCounts());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        }
    }

    @Override
    @Test
    public void testGetErrorResponse() {
        TxnOffsetCommitResponseData expectedResponse = new TxnOffsetCommitResponseData().setTopics(Arrays.asList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topicOne).setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setPartitionIndex(partitionOne))), new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topicTwo).setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setPartitionIndex(partitionTwo)))));
        Assertions.assertEquals((Object)expectedResponse, (Object)TxnOffsetCommitRequest.getErrorResponse((TxnOffsetCommitRequestData)TxnOffsetCommitRequestTest.builderWithGroupMetadata.data, (Errors)Errors.UNKNOWN_MEMBER_ID));
    }
}

