/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerClientInitialResponseTest {
    @Test
    public void testBuildClientResponseToBytes() throws Exception {
        String expectedMessage = "n,,\u0001auth=Bearer 123.345.567\u0001nineteen=42\u0001\u0001";
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("nineteen", "42");
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse("123.345.567", new SaslExtensions(extensions));
        String message = new String(response.toBytes(), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expectedMessage, (Object)message);
    }

    @Test
    public void testBuildServerResponseToBytes() throws Exception {
        String serverMessage = "n,,\u0001auth=Bearer 123.345.567\u0001nineteen=42\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(serverMessage.getBytes(StandardCharsets.UTF_8));
        String message = new String(response.toBytes(), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)serverMessage, (Object)message);
    }

    @Test
    public void testThrowsSaslExceptionOnInvalidExtensionKey() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("19", "42");
        Assertions.assertThrows(SaslException.class, () -> new OAuthBearerClientInitialResponse("123.345.567", new SaslExtensions(extensions)));
    }

    @Test
    public void testToken() throws Exception {
        String message = "n,,\u0001auth=Bearer 123.345.567\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"123.345.567", (Object)response.tokenValue());
        Assertions.assertEquals((Object)"", (Object)response.authorizationId());
    }

    @Test
    public void testAuthorizationId() throws Exception {
        String message = "n,a=myuser,\u0001auth=Bearer 345\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"345", (Object)response.tokenValue());
        Assertions.assertEquals((Object)"myuser", (Object)response.authorizationId());
    }

    @Test
    public void testExtensions() throws Exception {
        String message = "n,,\u0001propA=valueA1, valueA2\u0001auth=Bearer 567\u0001propB=valueB\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"567", (Object)response.tokenValue());
        Assertions.assertEquals((Object)"", (Object)response.authorizationId());
        Assertions.assertEquals((Object)"valueA1, valueA2", response.extensions().map().get("propA"));
        Assertions.assertEquals((Object)"valueB", response.extensions().map().get("propB"));
    }

    @Test
    public void testRfc7688Example() throws Exception {
        String message = "n,a=user@example.com,\u0001host=server.example.com\u0001port=143\u0001auth=Bearer vF9dft4qmTc2Nvb3RlckBhbHRhdmlzdGEuY29tCg\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"vF9dft4qmTc2Nvb3RlckBhbHRhdmlzdGEuY29tCg", (Object)response.tokenValue());
        Assertions.assertEquals((Object)"user@example.com", (Object)response.authorizationId());
        Assertions.assertEquals((Object)"server.example.com", response.extensions().map().get("host"));
        Assertions.assertEquals((Object)"143", response.extensions().map().get("port"));
    }

    @Test
    public void testCharSupportForRfc6750Token() throws Exception {
        String message = "n,a=user@example.com,\u0001host=server.example.com\u0001port=143\u0001auth=Bearer vF-9.df_t4qm~Tc2Nvb3RlckBhbHR+hdmlzdGEuY29/tCg==\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"vF-9.df_t4qm~Tc2Nvb3RlckBhbHR+hdmlzdGEuY29/tCg==", (Object)response.tokenValue());
        Assertions.assertEquals((Object)"user@example.com", (Object)response.authorizationId());
        Assertions.assertEquals((Object)"server.example.com", response.extensions().map().get("host"));
        Assertions.assertEquals((Object)"143", response.extensions().map().get("port"));
    }

    @Test
    public void testNoExtensionsFromByteArray() throws Exception {
        String message = "n,a=user@example.com,\u0001auth=Bearer vF9dft4qmTc2Nvb3RlckBhbHRhdmlzdGEuY29tCg\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"vF9dft4qmTc2Nvb3RlckBhbHRhdmlzdGEuY29tCg", (Object)response.tokenValue());
        Assertions.assertEquals((Object)"user@example.com", (Object)response.authorizationId());
        Assertions.assertTrue((boolean)response.extensions().map().isEmpty());
    }

    @Test
    public void testNoExtensionsFromTokenAndNullExtensions() throws Exception {
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse("token", null);
        Assertions.assertTrue((boolean)response.extensions().map().isEmpty());
    }

    @Test
    public void testValidateNullExtensions() throws Exception {
        OAuthBearerClientInitialResponse.validateExtensions(null);
    }
}

