/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.logout.impl.SAML2LogoutRequestBuilder;
import org.pac4j.saml.logout.impl.SAML2LogoutRequestMessageSender;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2LogoutActionBuilder
implements LogoutActionBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2LogoutActionBuilder.class);
    protected SAML2LogoutRequestBuilder saml2LogoutRequestBuilder;
    protected final SAML2LogoutRequestMessageSender saml2LogoutRequestMessageSender;
    protected final SAMLContextProvider contextProvider;
    protected final SAML2Configuration configuration;
    protected final ValueGenerator stateGenerator;
    protected final SAML2Client saml2Client;

    public SAML2LogoutActionBuilder(SAML2Client client) {
        this.saml2Client = client;
        this.saml2LogoutRequestMessageSender = client.getLogoutRequestMessageSender();
        this.contextProvider = client.getContextProvider();
        this.configuration = client.getConfiguration();
        this.stateGenerator = client.getStateGenerator();
        this.saml2LogoutRequestBuilder = new SAML2LogoutRequestBuilder(this.configuration);
    }

    public Optional<RedirectionAction> getLogoutAction(CallContext ctx, UserProfile currentProfile, String targetUrl) {
        try {
            if (currentProfile instanceof SAML2Profile) {
                SAML2Profile saml2Profile = (SAML2Profile)currentProfile;
                SAML2MessageContext samlContext = this.contextProvider.buildContext(ctx, this.saml2Client);
                String relayState = this.stateGenerator.generateValue(ctx);
                LogoutRequest logoutRequest = this.saml2LogoutRequestBuilder.build(samlContext, saml2Profile);
                this.saml2LogoutRequestMessageSender.sendMessage(samlContext, logoutRequest, relayState);
                WebContext webContext = ctx.webContext();
                Pac4jSAMLResponse adapter = samlContext.getProfileRequestContextOutboundMessageTransportResponse();
                if (this.configuration.getSpLogoutRequestBindingType().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
                    String content = adapter.getOutgoingContent();
                    return Optional.of(HttpActionHelper.buildFormPostContentAction((WebContext)webContext, (String)content));
                }
                String location = adapter.getRedirectUrl();
                return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)location));
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            LOGGER.warn(e.getMessage());
        }
        return Optional.empty();
    }
}

