/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.configuration.model.core.authentication.AuthenticationHandlerStates;
import org.apereo.cas.util.NamedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public interface AuthenticationHandlerResolver
extends Ordered {
    public static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationHandlerResolver.class);

    public static AuthenticationHandlerResolver noOp() {
        return new AuthenticationHandlerResolver(){

            @Override
            public Set<AuthenticationHandler> resolve(Set<AuthenticationHandler> candidateHandlers, AuthenticationTransaction transaction) {
                return new LinkedHashSet<AuthenticationHandler>();
            }

            @Override
            public boolean supports(Set<AuthenticationHandler> handlers, AuthenticationTransaction transaction) {
                return false;
            }
        };
    }

    default public Set<AuthenticationHandler> resolve(Set<AuthenticationHandler> candidateHandlers, AuthenticationTransaction transaction) throws Throwable {
        LinkedHashSet handlers = candidateHandlers.stream().filter(handler -> handler.getState() == AuthenticationHandlerStates.ACTIVE).collect(Collectors.toCollection(LinkedHashSet::new));
        if (LOGGER.isDebugEnabled()) {
            String handlerNames = handlers.stream().map(NamedObject::getName).collect(Collectors.joining(","));
            LOGGER.debug("Default authentication handlers used for this transaction are [{}]", (Object)handlerNames);
        }
        return handlers;
    }

    default public int getOrder() {
        return Integer.MIN_VALUE;
    }

    default public boolean supports(Set<AuthenticationHandler> handlers, AuthenticationTransaction transaction) throws Throwable {
        return !handlers.isEmpty() && transaction != null;
    }
}

