/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.eventregistry.json.converter.ChannelValidator;
import org.flowable.eventregistry.json.converter.FlowableEventJsonException;
import org.flowable.eventregistry.json.converter.InboundChannelModelValidator;
import org.flowable.eventregistry.json.converter.OutboundChannelModelValidator;
import org.flowable.eventregistry.model.CamelInboundChannelModel;
import org.flowable.eventregistry.model.CamelOutboundChannelModel;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionInboundChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionOutboundChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.model.JmsInboundChannelModel;
import org.flowable.eventregistry.model.JmsOutboundChannelModel;
import org.flowable.eventregistry.model.KafkaInboundChannelModel;
import org.flowable.eventregistry.model.KafkaOutboundChannelModel;
import org.flowable.eventregistry.model.OutboundChannelModel;
import org.flowable.eventregistry.model.RabbitInboundChannelModel;
import org.flowable.eventregistry.model.RabbitOutboundChannelModel;

public class ChannelJsonConverter {
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected List<ChannelValidator> validators = new ArrayList<ChannelValidator>();
    protected Map<String, Class<? extends ChannelModel>> channelModelClasses = new HashMap<String, Class<? extends ChannelModel>>();

    public ChannelJsonConverter() {
        this.addValidator(new OutboundChannelModelValidator());
        this.addValidator(new InboundChannelModelValidator());
        this.addDefaultChannelModelClasses();
    }

    public ChannelJsonConverter(Collection<ChannelValidator> validators) {
        this.validators = new ArrayList<ChannelValidator>(validators);
        this.addDefaultChannelModelClasses();
    }

    protected void addDefaultChannelModelClasses() {
        this.addInboundChannelModelClass("jms", JmsInboundChannelModel.class);
        this.addInboundChannelModelClass("rabbit", RabbitInboundChannelModel.class);
        this.addInboundChannelModelClass("kafka", KafkaInboundChannelModel.class);
        this.addInboundChannelModelClass("camel", CamelInboundChannelModel.class);
        this.addInboundChannelModelClass("expression", DelegateExpressionInboundChannelModel.class);
        this.addOutboundChannelModelClass("jms", JmsOutboundChannelModel.class);
        this.addOutboundChannelModelClass("rabbit", RabbitOutboundChannelModel.class);
        this.addOutboundChannelModelClass("kafka", KafkaOutboundChannelModel.class);
        this.addOutboundChannelModelClass("camel", CamelOutboundChannelModel.class);
        this.addOutboundChannelModelClass("expression", DelegateExpressionOutboundChannelModel.class);
    }

    public ChannelModel convertToChannelModel(String modelJson) {
        try {
            JsonNode channelNode = this.objectMapper.readTree(modelJson);
            Class<? extends ChannelModel> channelClass = this.determineChannelModelClass(channelNode);
            ChannelModel channelModel = (ChannelModel)this.objectMapper.convertValue((Object)channelNode, channelClass);
            this.validateChannel(channelModel);
            return channelModel;
        }
        catch (FlowableEventJsonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FlowableEventJsonException("Error reading channel json", e);
        }
    }

    protected Class<? extends ChannelModel> determineChannelModelClass(JsonNode channelNode) {
        String type;
        String channelType = channelNode.path("channelType").asText(null);
        Class<? extends ChannelModel> channelClass = this.channelModelClasses.get(channelType + "-" + (type = channelNode.path("type").asText(null)));
        if (channelClass != null) {
            return channelClass;
        }
        throw new FlowableEventJsonException("Not supported " + channelType + " channel model type was found " + type);
    }

    protected void validateChannel(ChannelModel channelModel) {
        for (ChannelValidator validator : this.validators) {
            validator.validateChannel(channelModel);
        }
    }

    public String convertToJson(ChannelModel definition) {
        try {
            return this.objectMapper.writeValueAsString((Object)definition);
        }
        catch (Exception e) {
            throw new FlowableEventJsonException("Error writing channel json", e);
        }
    }

    public List<ChannelValidator> getValidators() {
        return this.validators;
    }

    public void addValidator(ChannelValidator validator) {
        this.validators.add(validator);
    }

    public void setValidators(List<ChannelValidator> validators) {
        this.validators = validators;
    }

    public Map<String, Class<? extends ChannelModel>> getChannelModelClasses() {
        return this.channelModelClasses;
    }

    public void addOutboundChannelModelClass(String type, Class<? extends OutboundChannelModel> channelModelClass) {
        this.channelModelClasses.put("outbound-" + type, channelModelClass);
    }

    public void addInboundChannelModelClass(String type, Class<? extends InboundChannelModel> channelModelClass) {
        this.channelModelClasses.put("inbound-" + type, channelModelClass);
    }

    public void setChannelModelClasses(Map<String, Class<? extends ChannelModel>> channelModelClasses) {
        this.channelModelClasses = channelModelClasses;
    }
}

