/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.loader;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasCoreConfigurationUtils;
import org.apereo.cas.configuration.loader.BaseConfigurationPropertiesLoader;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlConfigurationPropertiesLoader
extends BaseConfigurationPropertiesLoader {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlConfigurationPropertiesLoader.class);

    @Override
    public PropertySource load(Resource resource, Environment environment, String name, CipherExecutor<String, String> configurationCipherExecutor) {
        Properties properties = new Properties();
        if (ResourceUtils.doesResourceExist((Resource)resource)) {
            try {
                Map<String, Object> yamlProperties = CasCoreConfigurationUtils.loadYamlProperties(resource);
                if (yamlProperties.isEmpty()) {
                    LOGGER.debug("No properties were located inside [{}]", (Object)resource);
                } else {
                    LOGGER.info("Found settings [{}] in YAML file [{}]", yamlProperties.keySet(), (Object)resource);
                    properties.putAll(this.decryptProperties(configurationCipherExecutor, yamlProperties));
                }
            }
            catch (YAMLException e) {
                LOGGER.warn("Error parsing yaml configuration in [{}]: [{}]", (Object)resource, (Object)e.getMessage());
                throw e;
            }
        }
        return this.finalizeProperties(name, properties);
    }

    @Override
    public boolean supports(Resource resource) {
        String filename = StringUtils.defaultString((String)resource.getFilename()).toLowerCase(Locale.ENGLISH);
        return filename.endsWith(".yaml") || filename.endsWith(".yml");
    }

    @Generated
    public YamlConfigurationPropertiesLoader() {
    }
}

