/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.ticket;

import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.IdleExpirationPolicy;
import org.apereo.inspektr.common.web.ClientInfo;

public abstract class AbstractCasTicketGrantingTicketEvent
extends AbstractCasEvent {
    private static final long serialVersionUID = 5815205609847140811L;
    private final AuthenticationAwareTicket ticketGrantingTicket;

    protected AbstractCasTicketGrantingTicketEvent(Object source, AuthenticationAwareTicket ticketGrantingTicket, ClientInfo clientInfo) {
        super(source, clientInfo);
        this.ticketGrantingTicket = ticketGrantingTicket;
    }

    public ZonedDateTime getCreationTime() {
        return this.ticketGrantingTicket.getCreationTime();
    }

    public String getId() {
        return this.ticketGrantingTicket.getId();
    }

    public Long getTimeToLive() {
        return this.ticketGrantingTicket.getExpirationPolicy().getTimeToLive();
    }

    public Long getTimeToIdle() {
        Long l;
        ExpirationPolicy expirationPolicy = this.ticketGrantingTicket.getExpirationPolicy();
        if (expirationPolicy instanceof IdleExpirationPolicy) {
            IdleExpirationPolicy iep = (IdleExpirationPolicy)expirationPolicy;
            l = iep.getTimeToIdle();
        } else {
            l = 0L;
        }
        return l;
    }

    public String getPrincipalId() {
        return this.ticketGrantingTicket.getAuthentication().getPrincipal().getId();
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractCasTicketGrantingTicketEvent(super=" + super.toString() + ", ticketGrantingTicket=" + String.valueOf(this.ticketGrantingTicket) + ")";
    }

    @Generated
    public AuthenticationAwareTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }
}

