!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_qij0
!! NAME
!! calc_qij0
!! 
!! FUNCTION
!! Compute Q_ij0 terms
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  pawps
!!    %phi(wav_meshsz,basis_size)= atomic partial waves
!!    %tphi(wav_meshsz,basis_size)= atomic pseudo partial waves
!!  pawdata
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pshead
!!    %lmn_size= Number of elements for the paw basis
!!    %log_step= Logaritmic step corresponding to radial mesh
!!    %sph_meshsz=Dimension of radial mesh for spheres
!! 
!! OUTPUT
!!  pawarray
!!    %qij0(lmn2_size)= qij_0 terms
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!      ctrap
!!
!! SOURCE

 subroutine calc_qij0(pawarray,pawdata,pawps,pshead)

 use defs_basis
 use defs_pawps

 implicit none
 
!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: il,ilmn,ilmin,ilmax,iln,j0lmn,jl,jlmn,jln,klmn
 real(dp),allocatable :: ff(:)

!--------------------------------------------------------

 pawarray%qij0=zero
 
 allocate(ff(pshead%sph_meshsz))

 do jlmn=1,pshead%lmn_size
  jl =pawdata%indlmn(1,jlmn)
  jln=pawdata%indlmn(5,jlmn)
  j0lmn=jlmn*(jlmn-1)/2
  do ilmn=1,jlmn
   il= pawdata%indlmn(1,ilmn)
   iln=pawdata%indlmn(5,ilmn)
   klmn=j0lmn+ilmn;ilmin=abs(jl-il);ilmax=jl+il
   if (il==jl) then
    ff(1:pshead%sph_meshsz)=&
&     ( pawps%phi (1:pshead%sph_meshsz,iln)&
&      *pawps%phi (1:pshead%sph_meshsz,jln)&
&     - pawps%tphi(1:pshead%sph_meshsz,iln)&
&      *pawps%tphi(1:pshead%sph_meshsz,jln) )&
&     *pawdata%rad_(1:pshead%sph_meshsz)
     call ctrap(pshead%sph_meshsz,ff,pshead%log_step,pawarray%qij0(klmn))
     pawarray%qij0(klmn)=pawarray%qij0(klmn)/sqrt(four_pi)
   endif
  enddo
 enddo

 deallocate(ff)

 end subroutine
!!***
