!{\src2tex{textfont=tt}}
!!****f* ABINIT/crho
!! NAME
!! crho
!!
!! FUNCTION
!! Calculate the charge density rho on the FFT grid.
!! In case of nsppol==2 calculate rho_up and rho_down 
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  irottb(nr,nop) = symmetry operations on the FFT grid.
!!  irottb(r,R)=index of (R**-1)r  in the FFT array where R is one of the nop
!!   symmetry operation in reciprocal space
!!  nbnds = number of bands.
!!  ninv = 2 if inversion symmetry, 1 otherwise.
!!  nkbz = number of k-points in the full Brillouin zone.
!!  nkibz = number of k-points in the irreducible Brillouin zone.
!!  nkibzm = maximum number of k-points in the irreducible Brillouin zone.
!!  nop = number of symmetry operations.
!!  nr = total number of points on the FFT grid.
!!  nrb = effective number of points on the FFT grid.
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  occ(nkibzm,nbnds,nsppol) = occupation numbers for nbnds bands at nkibzm irreducible k-points, for each spin
!!  ucvol = unit cell volume.
!!  wfr(nr,nbnds,nkibz,nsppol) = wavefunctions on the FFT grid for nbnds bands at nkibz irreducible k-points, for each spin
!!  wtk(nkibz) = irreducible k-points weights.
!!
!! OUTPUT
!!  omegaplasma = the plasma frequency.
!!  rho(nr,nsppol) = the density on the FFT grid.
!!   (total in first half and spin-up in second half if nsppol=2)
!!
!! NOTES
!!  The subroutine must be modified to take into account non-symmorphic
!!  operations 
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine crho(irottb,nbnds,ninv,nkbz,nkibz,nkibzm,nop,nr,nrb,nsppol,occ,omegaplasma,rho,ucvol,wfr,wtk,&
mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_lib01hidempi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: max_band_proc,min_band_proc,nbnds,ninv,nkbz,nkibz,nkibzm
 integer,intent(in) :: nop,nr,nrb,nsppol
 real(dp),intent(in) :: ucvol
 real(dp),intent(out) :: omegaplasma
 logical,intent(in) :: parallelism_is_on_bands
 type(MPI_type),intent(in) :: mpi_enreg
!arrays
 integer,intent(in) :: irottb(nr,nop)
 real(dp),intent(in) :: occ(nkibzm,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: wtk(nkibz)
 real(dp),intent(out) :: rho(nr,nsppol)
 complex,intent(in) :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)

!Local variables ------------------------------
!scalars
 integer :: ib,ier,ierr,ik,iop,ir,is,master,me,spaceComm
 real(dp) :: fact,rhoav,rs,tnepuc
 character(len=500) :: message
!arrays
 real(dp),allocatable :: rho2(:)

!*************************************************************************
 call xcomm_init(mpi_enreg,spaceComm)
!Init me
 call xme_init(mpi_enreg,me)
!Init master
 call xmaster_init(mpi_enreg,master)

 allocate(rho2(nr))

 write(message,'(a)')' crho: calculating charge density...'
 call wrtout(6,message,'COLL')

 !zero charge density
 rho(:,:)=0.0

!MG060914 added external loop on spin
 do is=1,nsppol

  rho2(:)=0.0
  !loop over k-points in IBZ
  do ik=1,nkibz
   !skip the higher bands if occupation is less than tol8
   !do while ((abs(occ(ik,ib,is))>tol8).and.(ib<=nbnds))
   do ib=1,nbnds
    if(parallelism_is_on_bands)then
     if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
    end if
    if(abs(occ(ik,ib,is))<tol8)cycle
    do ir=1,nr
     rho2(ir)=rho2(ir)+occ(ik,ib,is)*conjg(wfr(ir,ib,ik,is))*wfr(ir,ib,ik,is)*wtk(ik)
    end do !ir
   end do !ib
  end do !ik

  if(parallelism_is_on_bands) call xsum_mpi(rho2,spaceComm,ier)

  !loop over symmetry operations, symmetrising rho
  !factor 2 is for inversion
  fact=real(ninv)/(nkbz*ucvol)
  do iop=1,nop
   do ir=1,nr
    rho(ir,is)=rho(ir,is)+fact*rho2(irottb(ir,iop))
   end do
  end do

 end do ! is

!store the total charge in the first half only if nsspol==2 
 if (nsppol==2) then 
  rho2(:)=rho(:,1)
  rho(:,1)=rho(:,1)+rho(:,2)
  rho(:,2)=rho2(:)
 end if 

!write total charge
!open(unit=66,file='rho')
!write(66,'(f7.4)') (rho(ir),ir=1,nr)
!close(66)

!calculate total number of electrons as a check (using total charge)
 tnepuc=0.0
 do ir=1,nr
  tnepuc=tnepuc+rho(ir,1)
 end do
 
 deallocate(rho2)

 tnepuc=tnepuc*ucvol/nrb
 write(message,'(a,f9.4)')' total number of electrons per unit cell = ',tnepuc
 call wrtout(6,message,'COLL') 
 call wrtout(ab_out,message,'COLL')

 rhoav=tnepuc/ucvol
 write(message,'(a,f9.6)')' average of density, n = ',rhoav
 call wrtout(6,message,'COLL') 
 call wrtout(ab_out,message,'COLL')

 rs=(three/(four_pi*rhoav))**third
 write(message,'(a,f9.4)')' r_s = ',rs
 call wrtout(6,message,'COLL') 
 call wrtout(ab_out,message,'COLL')

 omegaplasma=sqrt(four_pi*rhoav)
 write(message,'(a,f9.4,2a)') ' omega_plasma = ',omegaplasma*Ha_eV,' [eV]',ch10
 call wrtout(6,message,'COLL') 
 call wrtout(ab_out,message,'COLL')

! deallocate(rho2)

end subroutine crho

!!***
