!{\src2tex{textfont=tt}}
!!****f* ABINIT/rel
!! NAME
!! rel
!!
!! FUNCTION
!! Calculate the relativistic correction to Vx.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  rho=density at one point in real space
!!
!! OUTPUT
!!  function rel=relativistic factor
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function rel(rho)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: rel
 real(dp),intent(in) :: rho

!Local variables-------------------------------
!scalars
 real(dp) :: b,rs

! *************************************************************************

 rs=(3.0/(4.0*pi*rho))**third
 b=0.0140/rs
 rel=-0.5+1.5*log(b+sqrt(1.0+b*b))/(b*sqrt(1.0+b*b))

 end function rel
!!***
